package com.bokesoft.yigo.meta.entry;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.EntryItemType;
import com.bokesoft.yigo.common.def.FormTarget;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaServiceRightsCollection;

public class MetaEntryItem extends AbstractCompositeObject {
	/** 入口项 */
	public static final int ENTRY_ITEM = 0;
	/** 入口项集合 */
	public static final int ENTRY = 1;
	
	/** 入口项标识 */
	private String key = "";
	/** 入口项名称 */
	private String caption = "";
	/** 入口项英文名称 */
	private String captionEn = "";
	/** 快捷键，以键值组合的形式表示，多个组之间以;分隔，比如CTRL+F1;ALT+1 */
	private String shortKeys = "";
	/** 入口类型，参见{@link EntryItemType} */
	private Integer type = -1;
	/** 表单的标识，在type取值为EntryType时有效 */
	private String formKey = "";
	/** 入口项事件，在type的取值为脚本EntryType.Form或定制EntryType.Custom时有效 */
	private MetaBaseScript action = null;
	/** 入口项点击事件，移动端使用，*/
	private MetaBaseScript onClick=null;
	/** 入口项可用性 */
	private String enable = "";
	/** 入口项可见性 */
	private String visible = "";
	/** 参数列表 */
	private String parameters = "";
	/** 图标 */
	private String icon = "";
	/** 视图 ，来源于MetaBody中的ViewCollection集合*/
	private String view = "";
	/** 模拟的媒体 */
	private Integer media = -1;
	/** 模拟的界面大小 */
	private String size = "";
	/** 单实例 */
	private Boolean single = true;
	/** 插件提供者 */
	private String provider = "";
	/** 工程引用 */
	private String project = null;
	/** 打开目标 */
	private Integer target = FormTarget.NEWTAB;
	
	private String rightsRelation = "";
	/** 事务码 */
	private String tCode = "";
	
	private MetaServiceRightsCollection serviceRightsCollection = null;
	
	/** 路径*/
	private String path = "";
	
	private String iconCode;
	
	public MetaEntryItem() {
		super();
	}
	
	@Override
	public int getCompositeType() {
		return ENTRY_ITEM;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { action, onClick });
	}

	public static final String TAG_NAME = "EntryItem";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equals(MetaConstants.Event_Action)) {
			action = new MetaBaseScript(MetaConstants.Event_Action);
			resultMetaObject = this.action;
		}else if (tagName.equals(MetaConstants.Event_OnClick)) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = this.onClick;
		}else if (tagName.equals(MetaServiceRightsCollection.TAG_NAME)) {
			serviceRightsCollection = new MetaServiceRightsCollection();
			resultMetaObject = this.serviceRightsCollection;
		}
		return resultMetaObject;
	}

	public MetaBaseScript getOnClick() {
		return onClick;
	}

	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

	public String getRightsRelation() {
		return rightsRelation;
	}

	public void setRightsRelation(String rightsRelation) {
		this.rightsRelation = rightsRelation;
	}

	/**
	 * 设置入口项标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得入口项标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}

	/**
	 * 设置入口项名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得入口项名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}

	/**
	 * 设置入口项英文名称
	 * @param captionEn 英文名称
	 */
	public void setCaptionEn(String captionEn) {
		this.captionEn = captionEn;
	}

	/**
	 * 取得入口项英文名称
	 * @return 英文名称
	 */
	public String getCaptionEn() {
		return this.captionEn;
	}
	
	/**
	 * 设置快捷方式
	 * @param shortKeys 快捷方式
	 * @see #shortKeys
	 */
	public void setShortKeys(String shortKeys) {
		this.shortKeys = shortKeys;
	}
	
	/**
	 * 取得快捷方式
	 * @return 快捷方式
	 * @see #shortKeys
	 */
	public String getShortKeys() {
		return this.shortKeys;
	}
	
	/**
	 * 设置入口类型
	 * @param type 入口类型
	 * @see #type
	 * @see EntryItemType
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 取得入口类型
	 * @return 入口类型
	 * @see #type
	 * @see EntryItemType
	 */
	public Integer getType() {
		return this.type;
	}
	
	/**
	 * 设置表单的标识
	 * @param formKey 表单标识
	 */
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	/**
	 * 取得表单标识
	 * @return 表单标识
	 */
	public String getFormKey() {
		return this.formKey;
	}
	
	/**
	 * 设置入口项事件
	 * @param action 入口项事件
	 */
	public void setAction(MetaBaseScript action) {
		this.action = action;
	}
	
	/**
	 * 取得入口项事件
	 * @return 入口项事件
	 */
	public MetaBaseScript getAction() {
		return this.action;
	}
	
	/**
	 * 设置可用性条件，为常量或者表达式
	 * @param enable 可用性条件
	 */
	public void setEnable(String enable) {
		this.enable = enable;
	}
	
	/**
	 * 取得可用性条件
	 * @return 可用性条件
	 */
	public String getEnable() {
		return this.enable;
	}
	
	/**
	 * 设置可见性条件，为常量或者表达式
	 * @param visible 可见性条件
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}
	
	/**
	 * 取得可见性条件
	 * @return 可见性条件
	 */
	public String getVisible() {
		return this.visible;
	}
	
	/**
	 * 设置参数列表
	 * @param parameters 参数列表
	 */
	public void setParameters(String parameters) {
		this.parameters = parameters;
	}
	
	/**
	 * 取得参数列表
	 * @return 参数列表
	 */
	public String getParameters() {
		return this.parameters;
	}
	
	/**
	 * 设置图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	/**
	 * 取得图标
	 * @return 图标
	 */
	public String getIcon() {
		return this.icon;
	}
	
	/**
	 * 设置视图
	 * @param view 视图
	 */
	public void setView(String view) {
		this.view = view;
	}
	
	/**
	 * 取得视图
	 * @return 视图
	 */
	public String getView() {
		return this.view;
	}
	
	/**
	 * 设置媒体
	 * @param media 媒体
	 */
	public void setMedia(Integer media) {
		this.media = media;
	}
	
	/**
	 * 取得媒体
	 * @return 媒体
	 */
	public Integer getMedia() {
		return this.media;
	}
	
	/**
	 * 设置大小
	 * @param size 大小
	 */
	public void setSize(String size) {
		this.size = size;
	}
	
	/**
	 * 取得大小
	 * @return 大小
	 */
	public String getSize() {
		return this.size;
	}
	
	/**
	 * 设置单实例
	 * @param single 单实例标志
	 */
	public void setSingle(Boolean single) {
		this.single = single;
	}
	
	/**
	 * 取得是否单实例
	 * @return 单实例标志
	 */
	public Boolean isSingle() {
		return this.single;
	}
	
	/**
	 * 设置插件提供者
	 * @param provider 插件提供者
	 */
	public void setProvider(String provider) {
		this.provider = provider;
	}
	
	/**
	 * 取得插件提供者
	 * @return 插件提供者
	 */
	public String getProvider() {
		return this.provider;
	}
	
	/**
	 * 设置工程引用
	 * @param project 工程引用
	 */
	public void setProject(String project) {
		this.project = project;
	}	
	
	/**
	 * 取得工程引用
	 * @return 工程引用
	 */
	public String getProject() {
		return this.project;
	}

	/**
	 * 设置打开目标
	 * @param target 打开目标
	 */
	public void setTarget(Integer target) {
		this.target = target;
	}
	
	/**
	 * 取得打开目标
	 * @return 打开目标
	 */
	public Integer getTarget() {
		return this.target;
	}
	
	/**
	 * 获取路径
	 * @return 路径
	 */
	public String getPath() {
		return path;
	}

	/**
	 * 设置路径 
	 * @param path 路径
	 */
	public void setPath(String path) {
		this.path = path;
	}

	/**
	 * 获取事务码
	 * @return
	 */
	public String getTCode() {
		return tCode;
	}

	/**
	 *设置事务码
	 * @param tCode
	 */
	public void setTCode(String tCode) {
		this.tCode = tCode;
	}
	
	public String getIconCode() {
		return iconCode;
	}

	public void setIconCode(String iconCode) {
		this.iconCode = iconCode;
	}
	
	/**
	 * 设置服务权限集合
	 * @param serviceRightsCollection 服务权限集合
	 */
	public void setServiceRightsCollection(MetaServiceRightsCollection serviceRightsCollection){
		this.serviceRightsCollection = serviceRightsCollection;
	}
	
	/**
	 * 获取服务权限集合
	 * @return 服务权限集合
	 */
	public MetaServiceRightsCollection getServiceRightsCollection(){
		return this.serviceRightsCollection;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaEntryItem newObject = new MetaEntryItem();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setCaptionEn(captionEn);
		newObject.setShortKeys(shortKeys);
		newObject.setType(type);
		newObject.setFormKey(formKey);
		newObject.setAction(action == null ? null : (MetaBaseScript)action.clone());
		newObject.setEnable(enable);
		newObject.setVisible(visible);
		newObject.setParameters(parameters);
		newObject.setView(view);
		newObject.setMedia(media);
		newObject.setSize(size);
		newObject.setSingle(single);
		newObject.setProvider(provider);
		newObject.setProject(project);
		newObject.setTarget(target);
		newObject.setRightsRelation(rightsRelation);
		newObject.setIcon(icon);
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObject.setTCode(tCode);
		newObject.setServiceRightsCollection(serviceRightsCollection == null ? null : (MetaServiceRightsCollection)serviceRightsCollection.clone()); 
		newObject.setIconCode(iconCode);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEntryItem();
	}
}
