package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaExtStartListener为应用启动时的需要执行的额外初始化操作的集合
 * @author wangyh
 *
 */
public class MetaExtStartListener extends GenericNoKeyCollection<MetaStartListener> implements IElementMerge<MetaExtStartListener> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "ExtStartListener";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaStartListener.TAG_NAME.equals(tagName) ) {
			MetaStartListener listener = new MetaStartListener();
			this.add(listener);
			resultMetaObject = listener;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtStartListener();
	}

	@Override
	public MetaExtStartListener toMerge(MetaExtStartListener obj) {
		if (obj != null) {
			Iterator<MetaStartListener> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaStartListener metaStartListener = (MetaStartListener) iterator.next();
				add(metaStartListener);
			}
		}
		return this;
	}

}
