package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtService extends GenericKeyCollection<MetaService> implements IElementMerge<MetaExtService>{

	public static final String TAG_NAME = "ExtService";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(MetaService.TAG_NAME.equals(tagName)){
			MetaService service = new MetaService();
			service.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(service);
			resultMetaObject = service;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No MetaObject defined for " + tagName);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtService();
	}

	@Override
	public MetaExtService toMerge(MetaExtService obj) {
		if (obj != null) {
			Iterator<MetaService> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaService metaService = (MetaService) iterator.next();
				if (containsKey(metaService.getKey())) {
					throw new MetaException(MetaException.REPEAT_EXT_SERVICE_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatExtServiceDefined),
									metaService.getKey()));
				}
				add(metaService);
			}
		}
		return this;
	}

}
