package com.bokesoft.yigo.meta.deploy;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaDeploy定义部署信息
 * @author wangyh
 *
 */
public class MetaDeploy extends AbstractMetaObject {
	/** 工程列表 */
	private MetaDeployProjects projects = null;
	/** 是否包含数据权限表*/
	private Boolean includedRightsSchema = false;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Deploy";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaDeployProjects.TAG_NAME.equals(tagName) ) {
			projects = new MetaDeployProjects();
			resultMetaObject = projects;
		}
		return resultMetaObject;
	}
	
	/**
	 * 设置工程列表
	 * @param projects 工程列表
	 */
	public void setProjects(MetaDeployProjects projects) {
		this.projects = projects;
	}
	
	/**
	 * 取得工程列表
	 * @return 工程列表
	 */
	public MetaDeployProjects getProjects() {
		return this.projects;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDeploy newObject = (MetaDeploy)newInstance();
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDeploy();
	}

	/**
	 * 设置是否包含数据权限表
	 * @param b 是否包含
	 */
	public void setIncludedRightsSchema(Boolean b) {
		this.includedRightsSchema = b;
	}
	
	/**
	 * 获取是否包含数据权限表
	 * @return 是否包含
	 */
	public Boolean isIncludedRightsSchema(){
		return this.includedRightsSchema;
	}

}
