package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 迁移检查规则的集合
 * 
 * @author 刘翔翔
 *
 */
public class MetaMigrationCheckRuleCollection extends GenericNoKeyCollection<MetaMigrationCheckRule> {

	public static final String TAG_NAME = "MigrationCheckRuleCollection";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaMigrationValueCompare.TAG_NAME.equals(tagName)) {
			MetaMigrationValueCompare checkRule = new MetaMigrationValueCompare();
			this.add(checkRule);
			resultMetaObject = checkRule;
		} else if (MetaMigrationCheckScript.TAG_NAME.equals(tagName)) {
			MetaMigrationCheckScript checkRule = new MetaMigrationCheckScript();
			this.add(checkRule);
			resultMetaObject = checkRule;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMigrationCheckRuleCollection();
	}

}
