package com.bokesoft.yigo.meta.datamigration;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import org.apache.commons.lang3.StringUtils;

/**
 * MetaDMSourceTableCollection定义了迁移关系中源表的集合，集合中的所有表只能来源于同一个数据对象定义。该类仅仅作为一个容器，具体的定义包括以下内容：
 * <p>源数据对象元数据的标识，决定了数据来源的数据对象元数据，表集合中的所有表的标识都只能从该数据对象定义的表集合中选择。</p>
 * <p>表集合，选择需要迁移的数据表集合定义，表可以是任何数据表，不限于需要持久化的数据表。表的定义详见{@link MetaDMSourceTable}</p>
 * @author 王元和
 * @since YES 1.0
 * @see MetaDMSourceTable
 */
public class MetaDMSourceTableCollection extends GenericKeyCollection<MetaDMSourceTable>implements Cloneable , IPropertyMerger<MetaDMSourceTableCollection> {
	/** 水平位置 */
	private Integer x = -1;
	/** 垂直位置 */
	private Integer y = -1;
	/** 宽度 */
	private Integer width = -1;
	/** 高度 */
	private Integer height = -1;
	
	public MetaDMSourceTableCollection() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "SourceTableCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置水平位置
	 * @param x 水平位置
	 */
	public void setX(Integer x) {
		this.x = x;
	}
	
	/**
	 * 取得水平位置
	 * @return 水平位置
	 */
	public Integer getX() {
		return this.x;
	}
	
	/**
	 * 设置垂直位置
	 * @param y 垂直位置
	 */
	public void setY(Integer y) {
		this.y = y;
	}
	
	/**
	 * 取得垂直位置
	 * @return 垂直位置
	 */
	public Integer getY() {
		return this.y;
	}
	
	/**
	 * 设置宽度
	 * @param width 宽度
	 */
	public void setWidth(Integer width) {
		this.width = width;
	}
	
	/**
	 * 取得宽度
	 * @return 宽度
	 */
	public Integer getWidth() {
		return this.width;
	}
	
	/**
	 * 设置高度
	 * @param height 高度
	 */
	public void setHeight(Integer height) {
		this.height = height;
	}
	
	/**
	 * 取得高度
	 * @return 高度
	 */
	public Integer getHeight() {
		return this.height;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaDMSourceTable.TAG_NAME.equals(tagName) ) {
			MetaDMSourceTable metaDMSourceTable = new MetaDMSourceTable();
			metaDMSourceTable.preProcessMetaObject(env, doc, node, flag, runType);
			if (StringUtils.isEmpty(metaDMSourceTable.getKey()) && StringUtils.isNotEmpty(metaDMSourceTable.getTableKey())){
				metaDMSourceTable.setKey(metaDMSourceTable.getTableKey());;
				metaDMSourceTable.setTableKey("");
			}
			this.add(metaDMSourceTable);
			resultMetaObject = metaDMSourceTable;
		}

		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDMSourceTableCollection();
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaDMSourceTableCollection newSourceTableCollection = (MetaDMSourceTableCollection) super.clone();
		newSourceTableCollection.setX(x);
		newSourceTableCollection.setY(y);
		newSourceTableCollection.setWidth(width);
		newSourceTableCollection.setHeight(height);
		return newSourceTableCollection;
	}

	@Override
	public void merge(MetaDMSourceTableCollection metaDMSourceTables) {
		for (MetaDMSourceTable metaDMSourceTable : metaDMSourceTables) {
			String key = metaDMSourceTable.getKey();
			MetaDMSourceTable metaSourceTable = this.get(key);
			// 如果不包括当前表则整体添加
			if(metaSourceTable == null){
				this.add(metaDMSourceTable);

			}else {
				metaSourceTable.merge(metaDMSourceTable);
			}
		}
	}
}
