package com.bokesoft.yigo.meta.datamigration;

/**
 * 源字段的类型，取值如下：
 * <ul>
 * <li>FIELD 来源于字段域
 * <li>FORMULA 来源于公式
 * <li>CONST 来源于常量
 * </ul>
 */
public class DMFieldType {
	/** 字段域 */
	public static final int FIELD = 0;
	/** 字段域字符串表示 */
	public static final String STR_FIELD = "Field";

	/** 表达式 */
	public static final int FORMULA = 1;
	/** 表达式字符串表示 */
	public static final String STR_FORMULA = "Formula";

	/** 常量 */
	public static final int CONST = 2;
	/** 常量字符串表示 */
	public static final String STR_CONST = "Const";
	
	public static int parse(String s) {
		int type = -1;
		if ( STR_FIELD.equalsIgnoreCase(s) ) {
			type = FIELD;
		} else if ( STR_FORMULA.equalsIgnoreCase(s) ) {
			type = FORMULA;
		} else if ( STR_CONST.equalsIgnoreCase(s) ) {
			type = CONST;
		}
		return type;
	}
	
	public static String toString(int type) {
		String s = null;
		switch ( type ) {
		case FIELD:
			s = STR_FIELD;
			break;
		case FORMULA:
			s = STR_FORMULA;
			break;
		case CONST:
			s = STR_CONST;
			break;
		}
		return s;
	}
}
