package com.bokesoft.yigo.meta.datamap.target;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.datamap.MetaMapConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.datamap.source.FieldType;

/**
 * 字段的反填属性
 * 
 * @author 刘翔翔
 *
 */
public class MetaFeedback extends AbstractMetaObject {

	/** 标签名 */
	public static final String TAG_NAME = "Feedback";
	/** 反填目标数据对象标识 */
	private String dataObjectKey = "";
	/** 反填目标表格标识 */
	private String tableKey = "";
	/** 反填目标字段标识 */
	private String fieldKey = "";
	/** 反填条件 */
	private String condition = "";
	/** 映射数据的处理方式 */
	private Integer opSign = FieldType.OP_ASSIGN;
	/** 映射反填后期处理类 */
	private MetaBaseScript postFormulaTrigger = null;
	/** 映射反填后期处理类 */
	private MetaBaseScript postTrigger = null;

	// 预处理的内容
	/** 常量值 */
	private Object constValue;
	/** 映射是否需要进行值的类型的转换 */
	private boolean needTypeConvert = false;
	/** 类型的转换的目标类型 */
	private int targetFieldDataType = -1;
	/** 映射反填后期处理类的路径 */
	private String postClassPath = null;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {postTrigger, postFormulaTrigger});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaMapConstants.FEEDBACK_POST_TRIGGER.equals(tagName)) {
			this.postTrigger = new MetaBaseScript(MetaMapConstants.FEEDBACK_POST_TRIGGER);
			resultMetaObject = this.postTrigger;
		} else if (MetaMapConstants.FEEDBACK_POST_FORMULA_TRIGGER.equals(tagName)) {
			this.postFormulaTrigger = new MetaBaseScript(MetaMapConstants.FEEDBACK_POST_FORMULA_TRIGGER);
			resultMetaObject = this.postFormulaTrigger;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFeedback newObject = new MetaFeedback();
		newObject.setDataObjectKey(dataObjectKey);
		newObject.setTableKey(tableKey);
		newObject.setFieldKey(fieldKey);
		newObject.setCondition(condition);
		newObject.setOpSign(opSign);
		newObject.setPostFormulaTrigger(postFormulaTrigger == null ? null : (MetaBaseScript)postFormulaTrigger.clone()); 
		newObject.setPostTrigger(postTrigger == null ? null : (MetaBaseScript)postTrigger.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFeedback();
	}

	public String getDataObjectKey() {
		return dataObjectKey;
	}

	public void setDataObjectKey(String dataObjectKey) {
		this.dataObjectKey = dataObjectKey;
	}

	public String getTableKey() {
		return tableKey;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	public String getFieldKey() {
		return fieldKey;
	}

	public void setFieldKey(String fieldKey) {
		this.fieldKey = fieldKey;
	}

	public Integer getOpSign() {
		return opSign;
	}

	public void setOpSign(Integer opSign) {
		this.opSign = opSign;
	}

	public MetaBaseScript getPostTrigger() {
		return postTrigger;
	}

	public void setPostTrigger(MetaBaseScript postTrigger) {
		this.postTrigger = postTrigger;
	}

	public Object getConstValue() {
		return constValue;
	}

	public void setConstValue(Object constValue) {
		this.constValue = constValue;
	}

	public boolean isNeedTypeConvert() {
		return needTypeConvert;
	}

	public void setNeedTypeConvert(boolean needTypeConvert) {
		this.needTypeConvert = needTypeConvert;
	}

	public int getTargetFieldDataType() {
		return targetFieldDataType;
	}

	public void setTargetFieldDataType(int targetFieldDataType) {
		this.targetFieldDataType = targetFieldDataType;
	}

	public String getPostClassPath() {
		return postClassPath;
	}

	public void setPostClassPath(String postClassPath) {
		this.postClassPath = postClassPath;
	}

	public String getCondition() {
		return condition;
	}

	public MetaBaseScript getPostFormulaTrigger() {
		return postFormulaTrigger;
	}

	public void setPostFormulaTrigger(MetaBaseScript postFormulaTrigger) {
		this.postFormulaTrigger = postFormulaTrigger;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}
}
