package com.bokesoft.yigo.meta.datamap.split;

/**
 * SplitType定义分数据拆分的类型，包括两种
 * <ul>
 * <li>分组拆分
 * <li>自定义拆分
 * </ul>
 * @author 王元和
 *
 */
public class SplitType {
	/** 分组拆分 */
	public static final int Group = 0;
	public static final String STR_Group = "Group";
	
	/** 自定义拆分 */
	public static final int Custom = 1;
	public static final String STR_Custom = "Custom";
	
	public static int parse(String s) {
		int type = -1;
		if ( STR_Group.equalsIgnoreCase(s) ) {
			type = Group;
		} else if ( STR_Custom.equalsIgnoreCase(s) ) {
			type = Custom;
		}
		return type;
	}
	
	public static String toString(Integer type) {
		if(type == null) {
			return "";
		}
		String s = null;
		switch ( type ) {
		case Group:
			s = STR_Group;
			break;
		case Custom:
			s = STR_Custom;
			break;
		}
		return s;
	}
}
