package com.bokesoft.yigo.meta.datamap.relatedatamap;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaRelateDataMap extends KeyPairMetaObject {

	/** 标签名 */
	public static final String TAG_NAME = "RelateDataMap";

	/** 关联数据映射的KEY */
	private String key = "";

	/** 数据计算方式是否为负向 */
	private Boolean negative = false;

	@Override
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRelateDataMap newObject = new MetaRelateDataMap();
		newObject.setKey(key);
		newObject.setNegative(negative);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelateDataMap();
	}

	public Boolean isNegative() {
		return negative;
	}

	public void setNegative(Boolean negative) {
		this.negative = negative;
	}

}
