package com.bokesoft.yigo.meta.commondef.resource;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaIconSource extends AbstractMetaObject {

	public static final String TAG_NAME = "IconSource";

	/** 标识 */
	private String key = "";

	/** 描述 */
	private String caption;
	
	/** 来源 */
	private String source;

	/** 显示模式 */
	private Integer displayMode;
	
	/** 场景 */
	private String scene;
	
	//后期赋值
	private String solutionKey;
	

	public MetaIconSource() {
		super();
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getCaption() {
		return caption;
	}

	public Integer getDisplayMode() {
		return displayMode;
	}

	public void setDisplayMode(Integer displayMode) {
		this.displayMode = displayMode;
	}
	
	public String getScene() {
		return scene;
	}

	public void setScene(String scene) {
		this.scene = scene;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getSolutionKey() {
		return solutionKey;
	}

	public void setSolutionKey(String solutionKey) {
		this.solutionKey = solutionKey;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaIconSource iconSource = (MetaIconSource) this.newInstance();
		iconSource.setKey(this.key);
		iconSource.setCaption(this.caption);
		iconSource.setDisplayMode(displayMode);
		iconSource.setScene(scene);
		iconSource.setSource(source);
		return iconSource;
	}


	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaIconSource();
	}

	public void merge(MetaIconSource source) {
		if( this.caption == null ) {
			this.caption = source.getCaption();
		}
		if( this.displayMode == null ) {
			this.displayMode = source.getDisplayMode();
		}
		if (this.source == null) {
			this.source = source.getSource();
		}
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	public Boolean verify(String key,String scene) {
		if (key == null) {
			return false;
		}
		if (scene == null) {
			return this.key.equals(key) && this.scene == null;
		}
		return this.key.equals(key) && this.scene.equals(scene);
	}
}
