package com.bokesoft.yigo.meta.commondef;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

/**
 * 窗口操作配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaOperation extends KeyPairCompositeObject implements IPropertyMerger<MetaOperation>{
	/** 操作 */
	public static final int Operation = 0;
	/** 操作集合 */
	public static final int OperationCollection = 1;
	/** 配置文件中对应片段的起始标签名称 */
	public static final String TAG_NAME = "Operation";
	/** 操作对象的标识 */
	private String key = "";
	/** 操作对象的说明 */
	private String caption = "";
	/** 操作对象的英文说明 */
	private String captionEn = "";
	/** 操作的具体内容 */
	private MetaBaseScript action = null;
	/** 异常处理 */
	private MetaBaseScript exceptionHandler = null;
	/** 操作是否可用 */
	private String enable = "";
	/** 操作是否可见 */
	private String visible = "";
	/** 可用性依赖*/
	private String enableDependency = "";
	/** 可见性依赖*/
	private String visibleDependency = "";
	/** 外部定义标识 */
	private String refKey = "";
	/** 处理标记 */
	private String tag = "";
	/** 图标 */
	private String icon = "";
	/** 自定义样式*/
	private String cssClass = "";
	/** 是否是扩展操作 */
	private Boolean expand = false;
	/** 扩展源 */
	private String expandSource = "";
	/** 被管理的操作(主要用于工作项中的扩展,不用控制权限) */
	private Boolean managed = false;
	/** 快捷键 */
	private String shortCuts = "";
	/** refKey是否已经初始化的标志 */
	private boolean refKeyInited = false;
	/** 是否记录操作日志 */
	private Boolean needAccessLog = false; 
	/**上传按钮是否多选*/
	private String uploadType = "";
	/** 事务码*/
	private String tCode = "";
	/** 作业值*/
	private String activity = "";

	private Boolean first = null;
	private Boolean last = null;
	/** 操作的定义前置预处理操作内容（次项属性是由逻辑处理代码添加的，不是配置对象的属性，不需要保存） */
	private MetaBaseScript preAction = null;

	/** 是否上传文件*/
	private Boolean uploadFile = false;
	
	private String iconCode;
	/** 显示模式 */
	private Integer displayMode;

	/** 是否触发传输 */
	private Boolean isTransfer;
	//定位
	private String sideKey = "";
	//是否插入之后
	private Boolean insertAfter = null;

	public MetaOperation() {
		super();
	}

	public Boolean getLast() {
		return last;
	}

	public void setLast(Boolean last) {
		this.last = last;
	}

	public String getSideKey() {
		return sideKey;
	}

	public void setSideKey(String sideKey) {
		this.sideKey = sideKey;
	}

	public Boolean getInsertAfter() {
		return insertAfter;
	}

	public void setInsertAfter(Boolean insertAfter) {
		this.insertAfter = insertAfter;
	}

	/**
	 * 设置外部定义标识
	 * 
	 * @param key
	 *            外部定义标识
	 */
	public void setRefKey(String key) {
		refKey = key;
	}

	/**
	 * 获取外部定义标识
	 * 
	 * @return 标识
	 */
	public String getRefKey() {
		return refKey;
	}

	/**
	 * 获取操作对象的标识
	 */
	@Override
	public String getKey() {
		return key;
	}

	/**
	 * 设置操作对象的标识
	 * 
	 * @param key
	 *            标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 获取操作对象的说明
	 * 
	 * @return 说明
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置操作对象的说明
	 * 
	 * @param caption
	 *            说明
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 获取操作对象的英文说明
	 *
	 * @return 英文说明
	 */
	public String getCaptionEn() {
		return captionEn;
	}

	/**
	 * 设置操作对象的英文说明
	 *
	 * @param captionEn
	 *            英文说明
	 */
	public void setCaptionEn(String captionEn) {
		this.captionEn = captionEn;
	}

	/**
	 * 设置操作对象的操作内容
	 * 
	 * @param action
	 *            操作内容
	 * @see MetaBaseScript
	 */
	public void setAction(MetaBaseScript action) {
		this.action = action;
	}

	/**
	 * 获取操作对象的操作内容
	 * 
	 * @return 操作内容
	 * @see MetaBaseScript
	 */
	public MetaBaseScript getAction() {
		return action;
	}
	
	/**
	 * 获取样式
	 * @return
	 */
	public String getCssClass() {
		return cssClass;
	}

	/**
	 * 设置样式
	 * @param cssClass
	 */
	public void setCssClass(String cssClass) {
		this.cssClass = cssClass;
	}

	/**
	 * 设置异常处理
	 * @param exceptionHandler 异常处理
	 */
	public void setExceptionHandler(MetaBaseScript exceptionHandler) {
		this.exceptionHandler = exceptionHandler;
	}
	
	/**
	 * 取得异常处理
	 * @return 异常处理
	 */
	public MetaBaseScript getExceptionHandler() {
		return this.exceptionHandler;
	}

	/**
	 * 设置操作是否可用
	 * 
	 * @param enable
	 *            是否可用
	 */
	public void setEnable(String enable) {
		this.enable = enable;
	}

	/**
	 * 获取操作是否可用
	 * 
	 * @return 是否可用
	 */
	public String getEnable() {
		return this.enable;
	}

	/**
	 * 设置操作是否可见
	 * 
	 * @param visible
	 *            是否可见
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}

	/**
	 * 获取操作是否可见
	 * 
	 * @return 是否可见
	 */
	public String getVisible() {
		return this.visible;
	}

	/**
	 * 设置处理标记
	 * 
	 * @param tag
	 *            标记
	 */
	public void setTag(String tag) {
		this.tag = tag;
	}

	/**
	 * 取得处理标记
	 * 
	 * @return 标记
	 */
	public String getTag() {
		return this.tag;
	}

	/**
	 * 设置图标路径
	 * 
	 * @param icon
	 *            图标路径
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}

	/**
	 * 取得图标路径
	 * 
	 * @return 图标路径
	 */
	public String getIcon() {
		return this.icon;
	}

	/**
	 * 设置是否扩展操作
	 * 
	 * @param expand
	 *            是否扩展操作标志
	 */
	public void setExpand(Boolean expand) {
		this.expand = expand;
	}

	/**
	 * 取得是否扩展操作
	 * 
	 * @return 是否扩展操作标志
	 */
	public Boolean isExpand() {
		return this.expand;
	}

	/**
	 * 设置扩展源
	 * 
	 * @param expandSource
	 *            扩展源
	 */
	public void setExpandSource(String expandSource) {
		this.expandSource = expandSource;
	}

	/**
	 * 取得扩展源
	 * 
	 * @return 扩展源
	 */
	public String getExpandSource() {
		return this.expandSource;
	}

	/**
	 * 设置管理标志
	 * 
	 * @param managed
	 *            管理标志
	 */
	public void setManaged(Boolean managed) {
		this.managed = managed;
	}

	/**
	 * 取得管理标志
	 * 
	 * @return 管理标志
	 */
	public Boolean isManaged() {
		return this.managed;
	}

	/**
	 * 获取快捷键
	 * 
	 * @return 快捷键
	 */
	public String getShortCuts() {
		return this.shortCuts;
	}

	/**
	 * 设置快捷键
	 * 
	 * @param s 快捷键
	 */
	public void setShortCuts(String s) {
		this.shortCuts = s;
	}
	
	/**
	 * 获取上传是否多选
	 * 
	 * @return 快捷键
	 */
	public String getUploadType() {
		return uploadType;
	}

	/**
	 * 设置上传是否多选
	 * 
	 * @return 快捷键
	 */
	public void setUploadType(String uploadType) {
		this.uploadType = uploadType;
	}

	/** 
	 * 获取事务码
	 * @return
	 */
	public String getTCode() {
		return tCode;
	}

	/**
	 * 设置作业值
	 * @param tCode
	 */
	public void setTCode(String tCode) {
		this.tCode = tCode;
	}

	/**
	 * 获取活动代码
	 * @return
	 */
	public String getActivity() {
		return activity;
	}

	/**
	 * 设置活动代码
	 * @param activity
	 */
	public void setActivity(String activity) {
		this.activity = activity;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[] {
				action, exceptionHandler
		});
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaConstants.Event_Action.equals(tagName)) {
			action = new MetaBaseScript(MetaConstants.Event_Action);
			resultMetaObject = action;
		} else if ( MetaConstants.Event_ExceptionHandler.equals(tagName) ) {
			exceptionHandler = new MetaBaseScript(MetaConstants.Event_ExceptionHandler);
			resultMetaObject = exceptionHandler;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaOperation newObject = new MetaOperation();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setCaptionEn(captionEn);
		newObject.setAction(action == null ? null : (MetaBaseScript) action.clone());
		newObject.setExceptionHandler(exceptionHandler == null ? null : (MetaBaseScript)exceptionHandler.clone());
		newObject.setEnable(enable);
		newObject.setVisible(visible);
		newObject.setRefKey(refKey);
		newObject.setTag(tag);
		newObject.setIcon(icon);
		newObject.setExpand(expand);
		newObject.setExpandSource(expandSource);
		newObject.setManaged(managed);
		newObject.setShortCuts(shortCuts);
		newObject.setCssClass(cssClass);
		newObject.setEnableDependency(enableDependency);
		newObject.setVisibleDependency(visibleDependency);
		newObject.setUploadFile(uploadFile);
		newObject.setUploadType(uploadType);
		newObject.setIconCode(iconCode);
		newObject.setDisplayMode(displayMode);
		newObject.setTCode(tCode);
		newObject.setActivity(activity);
		newObject.setTransfer(isTransfer);
		return newObject;
	}
	
	public void copyFrom(MetaOperation src) {
//		this.key = src.getKey();
		this.caption = src.getCaption();
		this.captionEn = src.getCaptionEn();
		this.action = src.getAction();
		this.exceptionHandler = src.getExceptionHandler();
		this.enable = src.getEnable();
		this.enableDependency = src.getEnableDependency();
		this.visible = src.getVisible();
		this.visibleDependency = src.getVisibleDependency();
		this.tag = src.getTag();
		this.icon = src.getIcon();
		this.expand = src.isExpand();
		this.expandSource = src.getExpandSource();
		this.managed = src.isManaged();
		this.shortCuts = src.getShortCuts();
		this.cssClass = src.getCssClass();
		this.uploadFile = src.isUploadFile();
		this.uploadType = src.getUploadType();
		this.iconCode = src.getIconCode();
		this.displayMode = src.getDisplayMode();
		this.isTransfer = src.isTransfer();
		if(this.tCode == null || this.tCode.length() == 0){
			this.tCode = src.getTCode();
		}
		if(this.activity == null || this.activity.length() == 0) {
			this.activity = src.getActivity();
		}
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaOperation();
	}

	@Override
	public int getObjectType() {
		return Operation;
	}

	/**
	 * 设置引用的上层操作标志是否已经处理的标志，不应从Yigo外部调用
	 * @param refKeyInited 标志
	 */
	@Deprecated
	public void setRefKeyInited(boolean refKeyInited) {
		this.refKeyInited = refKeyInited;
	}
	
	/**
	 * 取得引用的上层操作标志是否已经处理的标志，不应从Yigo外部调用
	 * @return 标志
	 */
	public boolean isRefKeyInited() {
		return this.refKeyInited;
	}

	/**
	 * 获取可用性依赖的字段,","隔开
	 * @return 取得可用性依赖字段定义
	 */
	public String getEnableDependency() {
		return enableDependency;
	}

	/**
	 * 设置可用性依赖的字段
	 * @param enableDependency 可用性依赖字段定义
	 */
	public void setEnableDependency(String enableDependency) {
		this.enableDependency = enableDependency;
	}

	/**
	 * 获取可见性依赖的字段,","隔开
	 * @return 可见性依赖字段定义
	 */
	public String getVisibleDependency() {
		return visibleDependency;
	}

	/**
	 * 设置可见性依赖的字段
	 * @param visibleDependency 可见性依赖字段定义
	 */
	public void setVisibleDependency(String visibleDependency) {
		this.visibleDependency = visibleDependency;
	}

	/**
	 * 取得预操作定义
	 * @return 预操作定义
	 */
	public MetaBaseScript getPreAction() {
		return preAction;
	}

	/**
	 * 设置预操作定义
	 * @param preAction 预操作定义
	 */
	public void setPreAction(MetaBaseScript preAction) {
		this.preAction = preAction;
	}
	
	/**
	 * 设置是否上传文件
	 * @param uploadFile 是否上传文件
	 */
	public void setUploadFile(boolean uploadFile) {
		this.uploadFile = uploadFile;
	}
	
	/**
	 * 获取是否上传文件
	 * @return 是否上传文件
	 */
	public Boolean isUploadFile() {
		return this.uploadFile;
	}
	
	@Override
	public boolean needCheckExtend() {
		return true;
	}
	
	/**
	 * 获取是否记录操作日志
	 * @return
	 */
	public Boolean getNeedAccessLog() {
		return needAccessLog;
	}

	/**
	 * 设置是否记录操作日志
	 * @param needAccessLog
	 */
	public void setNeedAccessLog(Boolean needAccessLog) {
		this.needAccessLog = needAccessLog;
	}
	
	public String getIconCode() {
		return iconCode;
	}

	public void setIconCode(String iconCode) {
		this.iconCode = iconCode;
	}
	
	public Integer getDisplayMode() {
		return displayMode;
	}

	public void setDisplayMode(Integer displayMode) {
		this.displayMode = displayMode;
	}

	public Boolean isTransfer() {
		return isTransfer;
	}

	public void setTransfer(Boolean transfer) {
		this.isTransfer = transfer;
	}

	@Override
	public void merge(MetaOperation metaOpt) {
		if( this.caption == null ) {
			this.caption = metaOpt.getCaption();
		}
		if( this.captionEn == null ) {
			this.captionEn = metaOpt.getCaptionEn();
		}
		MetaBaseScript action = metaOpt.getAction();
		if( action != null ) {
			if( this.action == null ) {
				this.action = (MetaBaseScript) action.clone();
			} else {
				this.refKey = "";
			}
		}
		MetaBaseScript expHandler = metaOpt.getExceptionHandler();
		if( expHandler != null ) {
			if( this.exceptionHandler == null ) {
				this.exceptionHandler = (MetaBaseScript) expHandler.clone();
			}			
		}
		if( this.enable == null ) {
			this.enable = metaOpt.getEnable();
		}
		if( this.visible == null ) {
			this.visible = metaOpt.getVisible();
		}
		if( this.enableDependency == null ) {
			this.enableDependency = metaOpt.getEnableDependency();
		}
		if( this.visibleDependency == null ) {
			this.visibleDependency = metaOpt.getVisibleDependency();
		}
		if( this.refKey == null ) {
			this.refKey = metaOpt.getRefKey();
		}
		if( this.tag == null ) {
			this.tag = metaOpt.getTag();
		}
		if( this.icon == null ) {
			this.icon = metaOpt.getIcon();
		}
		if( this.cssClass == null ) {
			this.cssClass = metaOpt.getCssClass();
		}
		if( this.expand == null ) {
			this.expand = metaOpt.isExpand();
		}
		if( this.expandSource == null ) {
			this.expandSource = metaOpt.getExpandSource();
		}
		if( this.managed == null ) {
			this.managed = metaOpt.isManaged();
		}
		if( this.shortCuts == null ) {
			this.shortCuts = metaOpt.getShortCuts();
		}
		if( this.needAccessLog == null ) {
			this.needAccessLog = metaOpt.getNeedAccessLog();
		}
		if( this.uploadFile == null) {
			this.uploadFile = metaOpt.isUploadFile();
		}
		if( this.uploadType == null) {
			this.uploadType = metaOpt.getUploadType();
		}
		if (refKeyInited) {
			
		}
		if (iconCode == null) {
			this.iconCode = metaOpt.getIconCode();
		}
		if (displayMode == null) {
			this.displayMode = metaOpt.getDisplayMode();
		}
		if( this.tCode == null) {
			this.tCode = metaOpt.getTCode();
		}
		if( this.activity == null) {
			this.activity = metaOpt.getActivity();
		}
		if(this.isTransfer == null){
			this.isTransfer = metaOpt.isTransfer();
		}
	}

	public void toMerge(MetaOperation metaOpt) {
		if (metaOpt.getInsertAfter() != null) {
			this.insertAfter = metaOpt.getInsertAfter();
		}
		if (!metaOpt.getSideKey().isEmpty()) {
			this.sideKey = metaOpt.getSideKey();
		}
		if (metaOpt.getFirst() != null) {
			this.first = metaOpt.getFirst();
		}
		if (metaOpt.getLast() != null) {
			this.last = metaOpt.getLast();
		}
		this.caption = metaOpt.getCaption();
		this.captionEn = metaOpt.getCaptionEn();
		this.action = metaOpt.getAction();
		this.exceptionHandler = metaOpt.getExceptionHandler();
		this.enable = metaOpt.getEnable();
		this.visible = metaOpt.getVisible();
		this.enableDependency = metaOpt.getEnableDependency();
		this.visibleDependency = metaOpt.getVisibleDependency();
		this.refKey = metaOpt.getRefKey();
		this.tag = metaOpt.getTag();
		this.icon = metaOpt.getIcon();
		this.cssClass = metaOpt.getCssClass();
		this.expand = metaOpt.isExpand();
		this.expandSource = metaOpt.getExpandSource();
		this.managed = metaOpt.isManaged();
		this.shortCuts = metaOpt.getShortCuts();
		this.needAccessLog = metaOpt.getNeedAccessLog();
		this.uploadFile = metaOpt.isUploadFile();
		this.uploadType = metaOpt.getUploadType();
		this.iconCode = metaOpt.getIconCode();
		this.displayMode = metaOpt.getDisplayMode();
		this.tCode = metaOpt.getTCode();
		this.activity = metaOpt.getActivity();
		this.isTransfer = metaOpt.isTransfer();
	}

	public void setFirst(Boolean first) {
		this.first = first;
	}

	public Boolean getFirst() {
		return first;
	}
}
