package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaQueryCollection extends GenericKeyCollection<MetaQuery>  implements IPropertyMerger<MetaQueryCollection> {
	public MetaQueryCollection() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "QueryCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaQuery.TAG_NAME.equals(tagName) ) {
			MetaQuery query = new MetaQuery();
			query.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(query);
			resultMetaObject = query;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaQueryCollection();
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		for( MetaQuery query : this ) {
			query.doPostProcess(flag, callback);
		}
	}

	@Override
	public void merge(MetaQueryCollection metaQueryCollection) {
		for (MetaQuery metaQuery : metaQueryCollection) {
			String key = metaQuery.getKey();
			MetaQuery metaQuery1 = this.get(key);
			if (metaQuery1 !=null){
				metaQuery1.merge(metaQuery);
			} else {
				this.add(metaQuery);
			}
		}
	}
}
