package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaComponentSetting extends AbstractMetaObject {
	/** 组件可见性条件 */
	private String visible = null;
	/** 组件可用性条件 */
	private String enable = null;
	
	public MetaComponentSetting() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "ComponentSetting";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置组件可见性条件
	 * @param visible 可见性条件
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}
	
	/**
	 * 取得组件可见性条件
	 * @return 可见性条件
	 */
	public String getVisible() {
		return this.visible;
	}
	
	/**
	 * 设置组件可用性条件
	 * @param enable 可用性条件
	 */
	public void setEnable(String enable) {
		this.enable = enable;
	}
	
	/**
	 * 取得组件可用性条件
	 * @return 可用性条件
	 */
	public String getEnable() {
		return this.enable;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaComponentSetting newObject = new MetaComponentSetting();
		newObject.setVisible(visible);
		newObject.setEnable(enable);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaComponentSetting();
	}

}
