package com.bokesoft.yigo.meta.bpm.total;

public class ProcessMapType {

	public static final int Form = 1;
	public static final String STR_Form = "Form";

	public static final int DataObject = 2;
	public static final String STR_DataObject = "DataObject";

	/**
	 * 从字符串解析关联类型
	 * 
	 * @param s
	 *            字符串
	 * @return 字符串对应的类型
	 */
	public static int parse(String s) {
		int type = Form;
		if (STR_Form.equalsIgnoreCase(s)) {
			type = Form;
		} else if (STR_DataObject.equalsIgnoreCase(s)) {
			type = DataObject;
		}
		return type;
	}

	/**
	 * 
	 * @param type
	 *            关联类型
	 * @return 字符串表示
	 */
	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = "";
		switch (type) {
		case Form:
			s = STR_Form;
			break;
		case DataObject:
			s = STR_DataObject;
			break;
		}
		return s;
	}
}
