package com.bokesoft.yigo.meta.bpm.process.node;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaGateWay extends MetaNode {

	public static final String TAG_NAME = "GateWay";
	
	/** 流转条件*/
	private String condition = "";
	@Override
	public int getNodeType() {
		return NodeType.GATE_WAY;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGateWay();
	}

	public String getCondition() {
		return condition;
	}
	
	public void setCondition(String condition) {
		this.condition = condition;
	}
	
	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.condition = json.getString("condition");
	}
	
	@Override
	public JSONObject toJSON() {
		JSONObject json = super.toJSON();
		json.put("condition", this.condition);
		return json;
	}
	
}
