package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItemCollection;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaDataOutput extends MetaNode {
	public static final String TAG_NAME = "DataOutput";
	
	private MetaBaseScript action = null;
	private MetaDataItemCollection dataItemCollection = null;
	
	public MetaDataItemCollection getDataItemCollection() {
		return dataItemCollection;
	}

	public void setDataItemCollection(MetaDataItemCollection dataItemCollection) {
		this.dataItemCollection = dataItemCollection;
	}
	
	public MetaBaseScript getAction() {
		return action;
	}

	public void setAction(MetaBaseScript action) {
		this.action = action;
	}

	@Override
	public int getNodeType() {
		return NodeType.DATA_OUTPUT;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDataOutput();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] {action, dataItemCollection});
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (MetaDataItemCollection.TAG_NAME.equals(tagName)) {
			dataItemCollection = new MetaDataItemCollection();
			child = dataItemCollection;
		}else if (BPMConstants.NODE_ACTION.equals(tagName)) {
			action = new MetaBaseScript(BPMConstants.NODE_ACTION);
			child = action;
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		 MetaDataOutput object = (MetaDataOutput) super.clone();
		 object.action = action == null ? null : (MetaBaseScript) action.clone();
		 object.dataItemCollection = dataItemCollection == null ? null : (MetaDataItemCollection)dataItemCollection.clone();
		 return object;
	}
	
	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		if (json.has("action")) {
			action = new MetaBaseScript(MetaConstants.Event_Action);
			action.fromJSON(json.getJSONObject("action"));
		}
		if (json.has("dataItemCollection")) {
			dataItemCollection = new MetaDataItemCollection();
			dataItemCollection.fromJSON(json.getJSONObject("dataItemCollection"));
		}
	}
	
	@Override
	public JSONObject toJSON() {
		JSONObject json = super.toJSON();
		if (action != null) {
			json.put("action", action.toJSON());
		}
		if (dataItemCollection != null) {
			json.put("dataItemCollection", dataItemCollection.toJSON());
		}
		return json;
	}

}
