package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaDirectAuditCondition;

public class MetaAudit extends MetaUserTask {

	public final static String TAG_NAME = "Audit";

	/** 是否驳回上一步 */
	private Boolean denyToLastNode = false;

	/** 自定义驳回目标节点 */
	private String denyNodeKey = "";

	/** 上一步审批驳回是否从当前节点直送 */
	private Boolean directAudit = false;

	/** 直送的条件 */
	private MetaDirectAuditCondition directAuditCondition = new MetaDirectAuditCondition();

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	public Boolean isDenyToLastNode() {
		return denyToLastNode;
	}

	public void setDenyToLastNode(Boolean denyToLastNode) {
		this.denyToLastNode = denyToLastNode;
	}

	public String getDenyNodeKey() {
		return denyNodeKey;
	}

	public void setDenyNodeKey(String denyNodeKey) {
		this.denyNodeKey = denyNodeKey;
	}

	public Boolean isDirectAudit() {
		return directAudit;
	}

	public void setDirectAudit(Boolean directAudit) {
		this.directAudit = directAudit;
	}

	public MetaDirectAuditCondition getDirectAuditCondition() {
		return directAuditCondition;
	}

	public void setDirectAuditCondition(MetaDirectAuditCondition directAuditCondition) {
		this.directAuditCondition = directAuditCondition;
	}

	@Override
	public int getNodeType() {
		return NodeType.AUDIT;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaAudit();
	}

	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		list.add(directAuditCondition);
	}

	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (child != null)
			return child;
		if (tagName.equalsIgnoreCase(MetaDirectAuditCondition.TAG)) {
			child = directAuditCondition;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}
}
