package com.bokesoft.yigo.meta.bpm.process.monitor;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaMonitorCollection extends GenericNoKeyCollection<MetaMonitor> implements IElementMerge<MetaMonitorCollection>{

	public final static String TAG_NAME = "MonitorCollection";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaMonitor.TAG_NAME.equals(tagName) ) {
			MetaMonitor monitor = new MetaMonitor();
			monitor.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(monitor);
			resultMetaObject = monitor;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMonitorCollection();
	}

	@Override
	public MetaMonitorCollection toMerge(MetaMonitorCollection obj) {
		if (obj != null) {
			Iterator<MetaMonitor> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaMonitor metaMonitor = (MetaMonitor) iterator.next();
				add(metaMonitor);
			}
		}
		return this;
	}

}
