package com.bokesoft.yigo.meta.bpm.process.attribute.parameter;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaStaticParameterCollection extends MetaBasicParameterCollection {
	public final static String TAG_NAME = "StaticParameterCollection";

	@Override
	protected MetaStaticParameter createChildMetaElement(String tagName) {
		MetaStaticParameter child =null;
		if (tagName.equalsIgnoreCase(MetaStaticParameter.TAG_NAME)) {
			child = new MetaStaticParameter();
		}
		return child;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStaticParameter();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		JSONArray queryParameterArray = new JSONArray();
		Iterator<MetaBasicParameter> it = this.elementArray.iterator();
		MetaStaticParameter metaStaticParameter = null;
		while (it.hasNext()) {
			metaStaticParameter = (MetaStaticParameter)it.next();
			queryParameterArray.put(metaStaticParameter.toJSON());
		}
		obj.put("staticparameteritems", queryParameterArray);
		
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		if (json.has("staticparameteritems")) {
			JSONArray staticParameterArray = json.getJSONArray("staticparameteritems");
			for (int i = 0, size = staticParameterArray.length(); i < size; ++i) {
				JSONObject staticParameterObj = staticParameterArray.getJSONObject(i);
				MetaStaticParameter metaStaticParameter  = new MetaStaticParameter();
				metaStaticParameter.fromJSON(staticParameterObj);
				this.add(metaStaticParameter);
			}
		}
	}
}
