package com.bokesoft.yigo.meta.archive;
/**
 * 归档条件用到的参数
 */

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaParam extends AbstractMetaObject{

	public final static String TAG_NAME="Param";
	
	/** 参数值*/
	private String value="";
	/** 参数类型*/
	private Integer dataType=DataType.INT;
	
	

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public Integer getDataType() {
		return dataType;
	}

	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaParam newObj = new MetaParam();
		newObj.value = value;
		newObj.dataType = dataType;
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaParam();
	}
	
	

}
