package com.bokesoft.yigo.meta.archive;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaArchiveRuleGroup extends GenericKeyCollectionWithKey<MetaArchiveRule> {

	public static final String TAG_NAME="RuleGroup";
	/** 组标识*/
	private String key="";
	/** 数据对象使用的归档规则映射*/
	private Map<String, MetaArchiveRule> objRuleMap = new HashMap<String, MetaArchiveRule>();
	
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaArchiveRule.TAG_NAME.equalsIgnoreCase(tagName)) {
			MetaArchiveRule rule = new MetaArchiveRule();
			rule.preProcessMetaObject(env, doc, node, flag, runType);
			add(rule);
			child = rule;
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaArchiveRuleGroup();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaArchiveRuleGroup newObj = (MetaArchiveRuleGroup)super.clone();
		newObj.key = key;
		return newObj;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		this.objRuleMap.clear();
		Iterator<MetaArchiveRule>iterator = iterator();
		while(iterator.hasNext()) {
			MetaArchiveRule rule = iterator.next();
			for (MetaArchiveObject obj : rule.getObjectCollection()) {
				objRuleMap.put(obj.getKey(), rule);
			}
		}
	}
	
	public MetaArchiveRule getObjRule(String objKey) {
		return objRuleMap.get(objKey);
	}

	public Map<String, MetaArchiveRule> getObjRuleMap() {
		return objRuleMap;
	}
	
	public MetaFieldCollection getObjCondition(String objKey) {
		MetaArchiveRule rule = objRuleMap.get(objKey);
		return rule.getFieldCollection();
	}

}
