package com.bokesoft.yes.meta.process.struct;

import java.util.ArrayList;
import java.util.Iterator;

public class WildcardExprToken extends ExprToken {
	private ArrayList<Integer> rows = null;
	private ArrayList<Integer> columns = null;
	public WildcardExprToken(int lexID, String lexValue) {
		super(lexID, lexValue);
		this.rows = new ArrayList<Integer>();
		this.columns = new ArrayList<Integer>();
	}
	
	@Override
	public boolean isWildcard() {
		return true;
	}
	
	public void addRow(int row) {
		this.rows.add(row);
	}
	
	public int findLastRow() {
		int rtn = -1;
		for ( int i = 0, size = this.rows.size(); i<size; ++i ) {
			Integer tmp = this.rows.get(i);
			if ( rtn == -1 ) {
				rtn = tmp;
			} else {
				rtn = Math.max(rtn, tmp);
			}
		}
		return rtn;
	}
	
	public int getRowSize() {
		return this.rows.size();
	}
	
	public int getRow(int index) {
		return this.rows.get(index);
	}
	
	public void addColumn(int column) {
		this.columns.add(column);
	}
	
	public int findLastColumn() {
		int rtn = -1;
		for ( int i = 0, size = this.columns.size(); i<size; ++i ) {
			Integer tmp = this.columns.get(i);
			if ( rtn == -1 ) {
				rtn = tmp;
			} else {
				rtn = Math.max(rtn, tmp);
			}
		}
		return rtn;
	}
	
	public int getColumnSize() {
		return this.columns.size();
	}
	
	public int getColumn(int index) {
		return this.columns.get(index);
	}
}
