package com.bokesoft.yes.meta.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaExtend;
import com.bokesoft.yigo.meta.common.MetaExtendCollection;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.common.MetaVar;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormPara;
import com.bokesoft.yigo.meta.form.MetaFormParaCollection;
import com.bokesoft.yigo.meta.form.MetaUICheckRule;
import com.bokesoft.yigo.meta.form.MetaUICheckRuleCollection;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.MetaEmbedVarCollection;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowCollection;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.util.MetaUtil;
 
public class MetaFormTemplateProcess {
	private IMetaFactory metaFactory = null;
	private MetaForm metaForm = null;
	private StringHashMap<MetaComponent> comsMap = null;
	
	public MetaFormTemplateProcess(IMetaFactory metaFactory, MetaForm metaForm) {
		this.metaFactory = metaFactory;
		this.metaForm = metaForm;
	}
	
	public void process() throws Throwable {
		if(metaForm.getFormType() == FormType.CompDict ||
				metaForm.getFormType() == FormType.Template){
			return;
		}
				
		MetaBody metaBody = metaForm.getMetaBody();
		if(metaBody != null){
			Iterator<MetaComponent> it = metaBody.iterator();
			MetaComponent metaComponent = null;
			while ( it.hasNext() ) {
				metaComponent = it.next();
				if ( metaComponent.isPanel() ) {
					this.processPanel((MetaPanel)metaComponent);
				} else if ( metaComponent.getControlType() == ControlType.BLOCK ) {
					MetaBlock metaBlock = (MetaBlock)metaComponent;
					MetaComponent metaRoot = metaBlock.getRoot();
					if ( metaRoot.isPanel() ) {
						this.processPanel((MetaPanel)metaRoot);
					}
				}
			}
		}
		
		// 如果是内联数据对象则需要处理数据对象模板
		MetaDataSource dataSource = metaForm.getDataSource();
		if ( dataSource != null ) {
			MetaDataObject dataObject = dataSource.getDataObject();
			String refObjectKey = dataSource.getRefObjectKey();
			if ( dataObject != null && (refObjectKey == null || refObjectKey.isEmpty()) ) {
				MetaDataObjectTemplateProcess dataObjectProcess = new MetaDataObjectTemplateProcess(metaFactory, dataObject);
				dataObjectProcess.process();
			}
		}
	}
	
	private void buildMap(){
		
		this.comsMap = StringHashMap.newInstance();
		
		MetaBody metaBody = metaForm.getMetaBody();
		
		Stack<MetaComponent> stack = new Stack<MetaComponent>();
		for (int i = 0, size = metaBody.size(); i < size; ++i) {
			stack.push(metaBody.get(i));
		}
		
		MetaComponent meta = null;
		while (!stack.isEmpty()) {
			meta = stack.pop();
			if( meta.needCheckExtend() ) {
				this.comsMap.put(meta.getKey(), meta);				
			}
			
			for (int i = 0, size = meta.getComponentCount(); i < size; ++i) {
				stack.add(meta.getComponent(i));
			}
		}
	}
	
	// 模板组件列表
	private LinkedList<MetaComponent> embedArray = new LinkedList<>();
	
	/**
	 *  合并删除马甲模板组件
	 */
	private void checkTemplate(MetaPanel metaPanel) {
		Iterator<MetaComponent> it = metaPanel.iteratorComponent();
		MetaComponent meta1 = null;
		MetaComponent meta2 = null;
		MetaComponent embed = null;
		MetaPanel metaPanel1 = null;
		Iterator<MetaComponent> itr = null;
		List<MetaComponent> delList = new ArrayList<MetaComponent>();
		while( it.hasNext() ) {
			meta1 = it.next();
			
			if( meta1.isExtend() ) {
				meta2 = comsMap.get(meta1.getKey()); // 判断在源单中是否存在
				if( meta2 == null ) { // 源单中不存在,检查各个模板
					itr = embedArray.iterator();
					while( itr.hasNext() ) {
						embed = itr.next();
						if( embed.isPanel() ) {
							metaPanel1 = (MetaPanel)embed;
							meta2 = findComponent(metaPanel1, meta1.getKey());// 非继承的不在根
							if( meta2 != null ) {
								delList.add(meta1);// 找到了,不管是继承或者非继承,删除当前面板的组件
								break;
							}
						}
					}
				} else {
					delList.add(meta1);// 源单中存在,不会是继承,删除meta1
				}
			} else {
				itr = embedArray.iterator(); // 源单现在还无继承组件,不检查,重复后面直接报错
				while( itr.hasNext() ) {
					embed = itr.next();
					if( embed.isPanel() ) {
						metaPanel1 = (MetaPanel)embed;
						meta2 = findComponent(metaPanel1, meta1.getKey()); // 非继承的不在根
						if( meta2 != null && meta2.isExtend() ) {
							metaPanel1.removeComponent(meta2); // 删除前面的模板中继承的组件,以非继承组件为主
							break;
						}
					}
				}
			}
		
			if( meta1.isPanel() ) { // 递归下一层处理
				checkTemplate((MetaPanel) meta1); 
			}
		}
		it = delList.iterator();
		while( it.hasNext() ) { // 删除当前面板中不需要的组件
			metaPanel.removeComponent(it.next());
		}
	}
	
	private void processPanel(MetaPanel metaPanel) throws Throwable {
		Iterator<MetaComponent> it = metaPanel.iteratorComponent();
		MetaComponent metaComponent = null;
		ArrayList<MetaComponent> newTemplateComponentArray = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			if ( metaComponent.getControlType() == ControlType.EMBED ) {
				MetaEmbed metaEmbed = (MetaEmbed)metaComponent;
				
				metaForm.addEmbed(metaEmbed);
				
				if(newTemplateComponentArray == null){
					newTemplateComponentArray = new ArrayList<MetaComponent>();
				}
				// 模板的继承需要提前处理
				String extend = metaForm.getExtend();
				if( extend != null && !extend.isEmpty() ) {
					MetaForm metaForm = metaFactory.getMetaForm(extend);
					MetaEmbed parentEmbed = metaForm.embedByKey(metaEmbed.getKey());
					if( parentEmbed != null ) {
						metaEmbed.merge(parentEmbed);
					}						
				}
				HashMap<String, Object> varValues = new HashMap<String, Object>();
				MetaEmbedVarCollection vars = metaEmbed.getVars();
				for ( int i = 0, size = vars.size(); i<size; ++i ) {
					MetaVar var = vars.get(i);
					varValues.put(var.getKey(), var.getValue());
				}
				String templateFormKey = metaEmbed.getFormKey();
			
				MetaForm templateMetaForm = metaFactory.getMetaForm(templateFormKey);
				String rootKey = metaEmbed.getRootKey();

				MetaComponent tmpMetaComponent = this.findComponent(templateMetaForm, rootKey);
				if( tmpMetaComponent == null ) {
					throw new MetaException(MetaException.TEMPLATE_ROOT_NOT_FOUND,
							SimpleStringFormat.format(StringTable.getString(null, "", StringTable.TemplateRootNotFound),templateFormKey,rootKey));
				}
				
				MetaComponent newMetaComponent = (MetaComponent)tmpMetaComponent.depthClone();
                this.processTemplate(newMetaComponent, varValues);
				newMetaComponent.setWidth(metaComponent.getWidth());
				newMetaComponent.setHeight(metaComponent.getHeight());
				newMetaComponent.setArea(metaComponent.getArea());
				newMetaComponent.setX(metaComponent.getX());
				newMetaComponent.setY(metaComponent.getY());
				newMetaComponent.setXSpan(metaComponent.getXSpan());
				newMetaComponent.setYSpan(metaComponent.getYSpan());
				
				// 如果模板是面板,检查里面的组件,非面板无需检查
				if( newMetaComponent.isPanel() ) {
					if( this.comsMap == null ) {
						buildMap();
					}
					checkTemplate((MetaPanel) newMetaComponent);
				}
				
				newTemplateComponentArray.add(newMetaComponent);
				
				// 添加到面板集合
				this.embedArray.add(newMetaComponent);
				
				// 处理数据源
				if ( metaEmbed.isIncludeDataTable() ) {
					MetaDataObject sourceDataObject = MetaUtil.getDataObject(metaFactory,templateMetaForm);
					if(sourceDataObject != null){
						MetaDataObject targetDataObject = MetaUtil.getDataObject(metaFactory,metaForm);
						MetaDataObjectTemplateUtil util = new MetaDataObjectTemplateUtil(
								sourceDataObject, targetDataObject, "", varValues);
						util.replace();
					}
				}
				
				// 处理宏公式
				MetaMacroCollection metaMacroCollection = templateMetaForm.getMacroCollection();
				if(metaMacroCollection != null){
					MetaMacroCollection newCollection = metaForm.getMacroCollection() == null ? new MetaMacroCollection() : metaForm.getMacroCollection();
					for(MetaMacro metaMacro : metaMacroCollection){
						newCollection.add((MetaMacro) metaMacro.clone());
					}
					metaForm.setMacroCollection(newCollection);
				}
				
				// 处理界面参数
				MetaFormParaCollection metaFormParaCollection = templateMetaForm.getFormParaCollection();
				if(metaFormParaCollection != null){
					MetaFormParaCollection newCollection = metaForm.getFormParaCollection() == null ?  new MetaFormParaCollection() : metaForm.getFormParaCollection();
					for(MetaFormPara metaFormPara : metaFormParaCollection){
						newCollection.add((MetaFormPara) metaFormPara.clone());
					}
					metaForm.setFormParaCollection(newCollection);
				}
				
				// 处理查询集合
				MetaQueryCollection metaQueryCollection = templateMetaForm.getQueryCollection();
				if(metaQueryCollection != null){
					MetaQueryCollection newCollection = metaForm.getQueryCollection() == null ? new MetaQueryCollection() : metaForm.getQueryCollection();
					for(MetaQuery metaQuery : metaQueryCollection){
						newCollection.add((MetaQuery) metaQuery.clone());
					}
					metaForm.setQueryCollection(newCollection);
				}
				
				// 处理扩展类集合
				MetaExtendCollection metaExtendCollection = templateMetaForm.getExtendCollection();
				if(metaExtendCollection != null){
					MetaExtendCollection newCollection = metaForm.getExtendCollection() == null ?  new MetaExtendCollection() : metaForm.getExtendCollection();
					for(MetaExtend metaExtend : metaExtendCollection){
						newCollection.add((MetaExtend) metaExtend.clone());
					}
					metaForm.setExtendCollection(newCollection);
				}
				
				// 处理界面检查
				MetaUICheckRuleCollection metaUICheckRuleCollection = templateMetaForm.getUICheckRuleCollection();
				if(metaUICheckRuleCollection != null){
					MetaUICheckRuleCollection newCollection = metaForm.getUICheckRuleCollection() == null ? new MetaUICheckRuleCollection() : metaForm.getUICheckRuleCollection();
					for(MetaUICheckRule metaUICheckRule : metaUICheckRuleCollection){
						newCollection.add((MetaUICheckRule) metaUICheckRule.clone());
					}
					metaForm.setUICheckRuleCollection(newCollection);
				}
				
				
			} else if ( metaComponent.isPanel() ){
				this.processPanel((MetaPanel)metaComponent);
			} else if ( metaComponent.getControlType() == ControlType.SUBDETAIL ) {
				MetaSubDetail metaSubDetail = (MetaSubDetail)metaComponent;
				MetaComponent root = metaSubDetail.getRoot();
				if( root != null && root.isPanel() ) {
					this.processPanel((MetaPanel) root);
				}
			}
		}
				
		if ( newTemplateComponentArray != null && !newTemplateComponentArray.isEmpty()) {
			LinkedList<MetaComponent> newComponentArray = new LinkedList<MetaComponent>();
			it = metaPanel.iteratorComponent();
			int index = 0;
			while ( it.hasNext() ) {
				metaComponent = it.next();
				if ( metaComponent.getControlType() == ControlType.EMBED ) {
					newComponentArray.add(newTemplateComponentArray.get(index));
					++index;
				} else {
					newComponentArray.add(metaComponent);
				}
			}
			metaPanel.clear();
			it = newComponentArray.iterator();
			while ( it.hasNext() ) {
				metaComponent = it.next();
				metaPanel.addComponent(metaComponent);
			}
		}
	}
	
	private MetaComponent findComponent(MetaForm targetMetaForm, String key) {
		MetaComponent metaComponent = null;
		MetaBody metaBody = targetMetaForm.getMetaBody();
		Iterator<MetaComponent> it = metaBody.iterator();
		MetaComponent tmpMetaComponent = null;
		while ( it.hasNext() ) {
			tmpMetaComponent = it.next();
			if ( key.equalsIgnoreCase(tmpMetaComponent.getKey()) ) {
				metaComponent = tmpMetaComponent;
			} else {
				if ( tmpMetaComponent.isPanel() ) {
					metaComponent = this.findComponent((MetaPanel)tmpMetaComponent, key);
				} if ( tmpMetaComponent.getControlType() == ControlType.BLOCK ) {
					MetaBlock metaBlock = (MetaBlock)tmpMetaComponent;
					MetaComponent metaRoot = metaBlock.getRoot();
					if(metaRoot.getKey().equalsIgnoreCase(key)){
						metaComponent = metaRoot;
					}else{
						if ( metaRoot.isPanel() ) {
							metaComponent = this.findComponent((MetaPanel)metaRoot, key);
						}
					}
				}
			}
			if ( metaComponent != null ) {
				break;
			}
		}
		return metaComponent;
	}
	
	private MetaComponent findComponent(MetaPanel metaPanel, String key) {
		MetaComponent metaComponent = null;
		Iterator<MetaComponent> it = metaPanel.iteratorComponent();
		MetaComponent tmpMetaComponent = null;
		while ( it.hasNext() ) {
			tmpMetaComponent = it.next();
			if ( key.equalsIgnoreCase(tmpMetaComponent.getKey()) ) {
				metaComponent = tmpMetaComponent;
			} else if ( tmpMetaComponent.isPanel() ) {
				metaComponent = this.findComponent((MetaPanel)tmpMetaComponent, key);
			}
			if ( metaComponent != null ) {
				break;
			}
		}
		return metaComponent;
	}
	
	private void processTemplate(MetaComponent metaComponent, HashMap<String, Object> vars) {
		if ( metaComponent.isPanel() ) {
			for ( int i = 0, size = metaComponent.getComponentCount(); i<size; ++i ) {
				MetaComponent metaChildComponent = metaComponent.getComponent(i);
				this.processTemplate(metaChildComponent, vars);
			}
		} else {
			switch ( metaComponent.getControlType() ) {
			case ControlType.LISTVIEW:
				this.processTemplateListView((MetaListView)metaComponent, vars);
				break;
			case ControlType.TILEDLIST:
			case ControlType.GALLERY:
			case ControlType.ROTATOR:
			case ControlType.ROTATORLIST:
			case ControlType.WATERFALL:
			case ControlType.EDITVIEW:
				this.processTemplateEditView((MetaEditView)metaComponent, vars);
				break;
			case ControlType.GRID:
				this.processTemplateGrid((MetaGrid)metaComponent, vars);
				break;
			default:
				this.processTemplateNormal(metaComponent, vars);
			}
		}
	}
	
	private void processTemplateGrid(MetaGrid metaGrid, HashMap<String, Object> vars) {
		MetaGridRowCollection rowCollection = metaGrid.getRowCollection();
		Iterator<MetaGridRow> itRow = rowCollection.iterator();
		MetaGridRow row = null;
		while ( itRow.hasNext() ) {
			row = itRow.next();
			switch ( row.getRowType() ) {
			case RowType.Fix: {
				for ( int i = 0, size = row.size(); i<size; ++i ) {
					MetaGridCell cell = row.get(i);
					MetaDataBinding dataBinding = cell.getDataBinding();
					if ( dataBinding != null ) {
						String tableKey = dataBinding.getTableKey();
						if ( tableKey != null && !tableKey.isEmpty() ) {
							dataBinding.setTableKey(SimpleStringFormat.format_v2(tableKey, vars));
						}
					}
				}
			}
				break;
			case RowType.Detail: {
				String tableKey = row.getTableKey();
				if ( tableKey != null && !tableKey.isEmpty() ) {
					row.setTableKey(SimpleStringFormat.format_v2(tableKey, vars));
				}
				for ( int i = 0, size = row.size(); i<size; ++i ) {
					MetaGridCell cell = row.get(i);
					MetaDataBinding dataBinding = cell.getDataBinding();
					if ( dataBinding != null ) {
						tableKey = dataBinding.getTableKey();
						if ( tableKey != null && !tableKey.isEmpty() ) {
							dataBinding.setTableKey(SimpleStringFormat.format_v2(tableKey, vars));
						}
					}
				}
			}
				break;
			}
		}
	}
	
	private void processTemplateListView(MetaListView metaListView, HashMap<String, Object> vars) {
		String tableKey = metaListView.getTableKey();
		if ( tableKey != null && !tableKey.isEmpty() ) {
			metaListView.setTableKey(SimpleStringFormat.format_v2(tableKey, vars));
		}
	}
	
	private void processTemplateEditView(MetaEditView metaEditView, HashMap<String, Object> vars) {
		String tableKey = metaEditView.getTableKey();
		if ( tableKey != null && !tableKey.isEmpty() ) {
			metaEditView.setTableKey(SimpleStringFormat.format_v2(tableKey, vars));
		}
	}
	
	private void processTemplateNormal(MetaComponent metaComponent, HashMap<String, Object> vars) {
		MetaDataBinding dataBinding = metaComponent.getDataBinding();
		if ( dataBinding != null ) {
			String tableKey = dataBinding.getTableKey();
			if ( tableKey != null && !tableKey.isEmpty() ) {
				dataBinding.setTableKey(SimpleStringFormat.format_v2(tableKey, vars));
			}
		}
	}
}
