package com.bokesoft.yes.meta.process;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map.Entry;

import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;

public class MetaDataObjectTemplateUtil {
	private MetaDataObject targetDataObject = null;
	private MetaDataObject sourceDataObject = null;
	private String tableKeys = "";
	private HashSet<String> sourceTables = null;
	private HashMap<String, Object> vars = null;
	public MetaDataObjectTemplateUtil(MetaDataObject sourceDataObject, MetaDataObject targetDataObject,
			 String tableKeys, HashMap<String, Object> vars) throws Exception {
		
		if(sourceDataObject == null) {
			throw new Exception("目标数据对象"+targetDataObject.getKey()+"没有获取到源数据对象");
		}
		
		this.sourceDataObject = sourceDataObject;
		this.targetDataObject = targetDataObject;
		
		this.tableKeys = tableKeys;
		this.vars = vars;
	}
	
	public void replace() {
		if ( tableKeys != null && !tableKeys.isEmpty() ) {
			this.sourceTables = new HashSet<String>();
			String[] v = tableKeys.split(",");
			for ( int i = 0, size = v.length; i<size; ++i ) {
				this.sourceTables.add(v[i]);
			}
		}
		
		MetaTableCollection sourceTableCollection = this.sourceDataObject.getTableCollection();
		MetaTableCollection targetTableCollection = this.targetDataObject.getTableCollection();

		sourceTableCollection.forEach(metaTable ->{
			String key = metaTable.getKey();
			if ( this.sourceTables == null || this.sourceTables.contains(key) ) {
				MetaTable newMetaTable = (MetaTable)metaTable.clone();
				newMetaTable.setKey(SimpleStringFormat.format_v2(key, vars));
				String dbKey = newMetaTable.getDBTableName();
				if ( dbKey != null && !dbKey.isEmpty() ) {
					newMetaTable.setDBTableName(SimpleStringFormat.format_v2(dbKey, vars));
				}
				
				String parentKey = metaTable.getParentKey();
				if ( parentKey != null && !parentKey.isEmpty() ) {
					newMetaTable.setParentKey(SimpleStringFormat.format_v2(parentKey, vars));
				}
				
                String indexPrefix = metaTable.getIndexPrefix();
                if (indexPrefix != null && !indexPrefix.isEmpty()) {
                    newMetaTable.setIndexPrefix(SimpleStringFormat.format_v2(indexPrefix, vars));
                }

                String primaryKey = metaTable.getPrimaryKey();
                if (primaryKey != null && !primaryKey.isEmpty()) {
                    newMetaTable.setPrimaryKey(SimpleStringFormat.format_v2(primaryKey, vars));
                }

                newMetaTable.forEach(col -> {
                    String refCol = col.getRefCol();
                    if (refCol != null && !refCol.isEmpty()) {
                        col.setRefCol(SimpleStringFormat.format_v2(refCol, vars));
                    }
                });

				//如果目标中已存在该表　则追加不存在的字段
				MetaTable targetTable = targetTableCollection.get(newMetaTable.getKey());
				if(targetTable != null){
					newMetaTable.forEach(col -> {
						if(!targetTable.containsKey(col.getKey())){
							targetTable.add((MetaColumn) col.clone());
						}
					});
				}else{
					targetTableCollection.add(newMetaTable);
				}
			}
		});
	}
}
