package com.bokesoft.yes.meta.persist.dom.xml;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.ex.XmlSyntaxException;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.CDataNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.CommentNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.DTDNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TextNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yes.meta.persist.dom.xml.parse.Element;
import com.bokesoft.yes.meta.persist.dom.xml.parse.Util;

public class XmlParser {

	private static boolean useComment = true;

	public static void setUseComment(boolean bool) {
		useComment = bool;
	}

	public static XmlTree parse(String xml) {
		return parse(xml, false);
	}
	
	public static XmlTree parse(String xml, boolean trimText) {
		List<Element> list = Util.getElements(xml);
		if ((list == null) || (list.size() == 0)) {
			return null;
		}

		int idx = -1;
		List<AbstractNode> listPreComment = new ArrayList<AbstractNode>();
		List<AbstractNode> listLastComment = new ArrayList<AbstractNode>();
		
		for (int i = 0; i < list.size(); i++) {
			Element e = (Element) list.get(i);
			if (e.type == Element.DTD) {
				continue;
			}
			if (e.type == Element.COMMENT) {
				listPreComment.add(new CommentNode(e.text));
				continue;
			}
			if (e.type == Element.TEXT) {
				if (StringUtil.isEmptyStr(e.text)) {
					continue;
				}
				throw new XmlSyntaxException("标签开始之前不能有文本[" + e.text.trim()
						+ "]");
			}
			if (e.type == Element.TAG) {
				idx = i;
				break;
			}
			throw new XmlSyntaxException("标签开始之前不能有CDATA[" + e.text.trim()
					+ "]");
		}

		if (idx == -1) {
			return null;
		}

		XmlTree tree = new XmlTree();
		TagNode node = new TagNode();
		tree.setRoot(node);

		Element ele = (Element) list.get(idx);

		node.setTagName(ele.tagName);
		if (ele.attrs != null) {
			node.setAttributes(ele.attrs);
		}

		Element endEle = getEndTagElement(list, idx, ele, node, trimText);
		if (endEle == null) {
			throw new XmlSyntaxException("root: <" + ele.tagName
					+ "> 没有找到对应的endTag");
		}

		for (int i = endEle.indexInTheList + 1; i < list.size(); i++) {
			Element e = (Element) list.get(i);
			if (e.type == Element.COMMENT) {
				listLastComment.add(new CommentNode(e.text));
			}
			if (e.type == Element.TAG) {
				throw new XmlSyntaxException("root: </" + ele.tagName
						+ "> 根标签的后面不能再有数据<" + e.tagName + ">");
			}
			if (e.type == Element.CDATA) {
				throw new XmlSyntaxException("root: </" + ele.tagName
						+ "> 根标签的后面不能再有数据CDATA[" + e.text + "]");
			}
			if ((e.type != Element.TEXT) || (StringUtil.isEmptyStr(e.text)))
				continue;
			throw new XmlSyntaxException("root: </" + ele.tagName
					+ "> 根标签的后面不能再有数据text[" + e.text.trim() + "]");
		}
		
		tree.addPreComment(listPreComment);
		tree.addLastComment(listLastComment);
		tree.updateMap();
		return tree;
	}

	private static Element getEndTagElement(List<Element> list, int bg,
			Element ele, TagNode node, boolean trimText) {
		if (ele.tagType == Element.T_NODE) {
			ele.indexInTheList = bg;
			return ele;
		}
		if (ele.tagType == Element.T_END) {
			throw new XmlSyntaxException("结尾标签</" + ele.tagName + "> 之前没有开始标签");
		}

		for (int i = bg + 1; i < list.size(); i++) {
			Element tem = (Element) list.get(i);
			if ((tem.type == Element.TEXT) || (tem.type == Element.COMMENT)
					|| (tem.type == Element.CDATA)) {
				if ((tem.type == Element.COMMENT) && (!useComment)) {
					continue;
				}
				if (trimText) {
					String txt = tem.text.trim();
					if (txt.length() > 0)
						node.addNode(makeNotTagNode(txt, tem.type));
				} else {
					node.addNode(makeNotTagNode(tem.text, tem.type));
				}

			} else if (tem.tagType == Element.T_NODE) {
				node.addNode(makeTagNode(tem));
			} else {
				if (tem.tagType == Element.T_END) {
					if (tem.tagName.equals(ele.tagName)) {
						tem.indexInTheList = i;
						return tem;
					}
					throw new XmlSyntaxException("endTag </" + tem.tagName
							+ " 之前没有开始节点");
				}

				TagNode newNode = makeTagNode(tem);
				node.addNode(newNode);
				Element newEd = getEndTagElement(list, i, tem, newNode, trimText);
				if (newEd == null) {
					throw new XmlSyntaxException("Tag <" + tem.tagName
							+ "> 没有找到对应的endTag");
				}

				i = newEd.indexInTheList;
			}

		}

		return null;
	}

	private static TagNode makeTagNode(Element ele) {
		TagNode node = new TagNode();
		node.setTagName(ele.tagName);
		if (ele.attrs != null) {
			node.setAttributes(ele.attrs);
		}
		return node;
	}
	
	private static AbstractNode makeNotTagNode(String text, int elemType) {
		if (Element.TEXT == elemType) {
			return new TextNode(text);
		} else if (Element.COMMENT == elemType) {
			return new CommentNode(text);
		} else if (Element.CDATA == elemType) {
			return new CDataNode(text);
		} else if (Element.DTD == elemType) {
			return new DTDNode(text);
		}
		throw new XmlSyntaxException("节点类型:" + elemType
				+ " 不存在！");
	}
}
