package com.bokesoft.yes.meta.persist.dom.solution;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.solution.MetaSolution;

public class MetaSolutionAction extends BaseDomAction<MetaSolution> {

	@Override
	public void load(Document document, Element element, MetaSolution meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, "Key", ""));
		meta.setCaption(DomHelper.readAttr(element, "Caption", ""));
		meta.setDataPath(DomHelper.readAttr(element, "DataPath", ""));
		meta.setStartForm(DomHelper.readAttr(element, "StartForm", ""));
		meta.setSecurityLevel(DomHelper.readAttr(element, "SecurityLevel", 10));
		meta.setEnableMultiLang(DomHelper.readAttr(element, "EnableMultiLang", false));
		meta.setDefaultLang(DomHelper.readAttr(element, "DefaultLang", "zh-CN"));
		meta.setTestLang(DomHelper.readAttr(element, "TestLang", ""));
		meta.setDesignEditorFactory(DomHelper.readAttr(element, "DesignEditorFactory", ""));
		meta.setEnableDiff(DomHelper.readAttr(element, MetaConstants.ENABLEDIFF, false));
	}

	@Override
	public void save(Document document, Element element, MetaSolution meta, int runType) {
		DomHelper.writeAttr(element, "Key", meta.getKey(), "");
		DomHelper.writeAttr(element, "Caption", meta.getCaption(), "");
		DomHelper.writeAttr(element, "DataPath", meta.getDataPath(), "");
		DomHelper.writeAttr(element, "StartForm", meta.getStartForm(), "");
		DomHelper.writeAttr(element, "SecurityLevel", meta.getSecurityLevel(), 10);
		DomHelper.writeAttr(element, "EnableMultiLang", meta.isEnableMultiLang(), false);
		DomHelper.writeAttr(element, "DefaultLang", meta.getDefaultLang(), "zh-CN");
		DomHelper.writeAttr(element, "TestLang", meta.getTestLang(), "");
		DomHelper.writeAttr(element, "DesignEditorFactory", meta.getDesignEditorFactory(), "");
		DomHelper.writeAttr(element, MetaConstants.ENABLEDIFF, meta.isEnableDiff(), false);
	}
	
}
