package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.parameter.MetaParameterLoad;
import com.bokesoft.yes.meta.persist.dom.paratable.MetaParaTableLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.parameter.MetaParameter;
import com.bokesoft.yigo.meta.parameter.MetaParameterID;
import com.bokesoft.yigo.meta.paratable.MetaParaGroup;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;
import com.bokesoft.yigo.meta.solution.MetaProject;
import org.json.JSONObject;

import java.util.Iterator;
import java.util.Map;

/**
 *
 */
public class MetaParameterScanLoad extends BaseMetaScanLoad{
    private MetaParameter parameter = null;
    private String solutionKey = "";
    public MetaParameterScanLoad(IMetaResolver resolver, MetaParameter parameter,String fileName,String solutionKey) {
        super(resolver, null, fileName, null);
        this.parameter = parameter;
        this.solutionKey = solutionKey;
    }
    @Override
    public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
        JSONObject profileInfo = resolver.readProfile(filePath, 0);
        if (profileInfo != null) {
            String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
            if (MetaParameter.TAG_NAME.equals(tagName)) {
                MetaParameterLoad load = new MetaParameterLoad(AppRunType.App);
                load.load(resolver, filePath);
                MetaParameter currentPT = (MetaParameter) load.getRootMetaObject();

                Iterator<Map.Entry<String, MetaParameterID>> itPT = currentPT.entryIterator();
                Map.Entry<String, MetaParameterID> entry = null;
                String groupKey = "";
                MetaParameterID metaPG = null;
                while (itPT.hasNext()) {
                    entry = itPT.next();
                    groupKey = entry.getKey();

                    MetaParameterID t = parameter.get(groupKey);

                    if (t != null) {
                        throw new RuntimeException("参数ID重复定义" + t.getKey()+" "+ t.getDescription());

//                        throw new MetaException(MetaException.REPEAT_PARA_GROUP_DEFINED, SimpleStringFormat.format(
//                                StringTable.getString(null, "", StringTable.RepeatParaGroupDefined), groupKey));
                    }
                    metaPG = entry.getValue();
                    metaPG.setSolution(solutionKey);
                    parameter.add(metaPG);

                }
            }
        }
    }
    @Override
    protected void scan(Object parent, String filePath) throws Throwable {
        loadMetaData(parent, "", filePath, filePath);
    }
}
