package com.bokesoft.yes.meta.persist.dom.setting;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.meta.setting.MetaSimpleSetting;

public class MetaSimpleSettingAction extends BaseDomAction<MetaSimpleSetting> {

	@Override
	public void load(Document document, Element element,
			MetaSimpleSetting meta, int runType) {
		NamedNodeMap attributes = element.getAttributes();
		if ( attributes != null ) {
			int length = attributes.getLength();
			for ( int i = 0; i<length; ++i ) {
				Node node = attributes.item(i);
				if ( node instanceof Attr ) {
					Attr attr = (Attr)node;
					meta.put(attr.getName(), attr.getValue());
				}
			}
		}
	}

	@Override
	public void save(Document document, Element element,
			MetaSimpleSetting meta, int runType) {
		HashMap<String, String> properties = meta.getProperties();
		Iterator<Entry<String, String>> it = properties.entrySet().iterator();
		Entry<String, String> entry = null;
		while ( it.hasNext() ) {
			entry = it.next();
			element.setAttribute(entry.getKey(), entry.getValue());
		}
	}

}
