package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.setting.ClusterType;
import com.bokesoft.yigo.meta.setting.MetaCluster;

public class MetaClusterAction extends BaseDomAction<MetaCluster> {

	@Override
	public void load(Document document, Element element, MetaCluster meta, int runType) {
		meta.setType(ClusterType.parse(DomHelper.readAttr(element, MetaConstants.CLUSTER_TYPE, "")));
		meta.setRefItemKey(DomHelper.readAttr(element, MetaConstants.CLUSTER_REFITEMKEY, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.COMMON_IMPL, ""));
		meta.setAdminItemKey(DomHelper.readAttr(element, MetaConstants.CLUSTER_ADMINITEMKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaCluster meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.CLUSTER_TYPE, ClusterType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaConstants.CLUSTER_REFITEMKEY, meta.getRefItemKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_IMPL, meta.getImpl(), "");
		DomHelper.writeAttr(element, MetaConstants.CLUSTER_ADMINITEMKEY, meta.getAdminItemKey(), "");
	}

}
