package com.bokesoft.yes.meta.persist.dom.rights;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.rights.MetaRightsDefinition;

public class MetaRightsDefinitionAction extends BaseDomAction<MetaRightsDefinition>{

	@Override
	public void load(Document document, Element element,
			MetaRightsDefinition meta, int runType) {
		meta.setAllRights(DomHelper.readAttr(element, MetaConstants.ALL_RIGHTS, false));
	}

	@Override
	public void save(Document document, Element element,
			MetaRightsDefinition meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.ALL_RIGHTS, meta.isAllRights(), false);
	}

}
