package com.bokesoft.yes.meta.persist.dom.report.embed;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.embed.MetaReportEmbedObject;

public class MetaReportEmbedObjectAction<T extends MetaReportEmbedObject> extends BaseDomAction<T> {

	@Override
	public void load(Document document, Element element, T meta, int runType) {
		meta.setX(DomHelper.readAttr(element, MetaReportConstants.EMBED_X, 0));
		meta.setY(DomHelper.readAttr(element, MetaReportConstants.EMBED_Y, 0));
		meta.setWidth(DomHelper.readAttr(element, MetaReportConstants.EMBED_WIDTH, 0));
		meta.setHeight(DomHelper.readAttr(element, MetaReportConstants.EMBED_HEIGHT, 0));
	}

	@Override
	public void save(Document document, Element element, T meta, int runType) {
		DomHelper.writeAttr(element, MetaReportConstants.EMBED_X, meta.getX(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.EMBED_Y, meta.getY(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.EMBED_WIDTH, meta.getWidth(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.EMBED_HEIGHT, meta.getHeight(), 0);
	}

}
