package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportWaterprint;

public class MetaReportWaterprintAction extends BaseDomAction<MetaReportWaterprint> {

	@Override
	public void load(Document document, Element element, MetaReportWaterprint meta, int runType) {
		meta.setSource(DomHelper.readAttr(element, MetaReportConstants.WATERPRINT_SOURCE, ""));
		meta.setWidth(DomHelper.readAttr(element, MetaReportConstants.WATERPRINT_WIDTH, 0));
		meta.setHeight(DomHelper.readAttr(element, MetaReportConstants.WATERPRINT_HEIGHT, 0));
		meta.setRepeat(DomHelper.readAttr(element, MetaReportConstants.WATERPRINT_REPEAT, true));
	}

	@Override
	public void save(Document document, Element element, MetaReportWaterprint meta, int runType) {
		DomHelper.writeAttr(element, MetaReportConstants.WATERPRINT_SOURCE, meta.getSource(), "");
		DomHelper.writeAttr(element, MetaReportConstants.WATERPRINT_WIDTH, meta.getWidth(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.WATERPRINT_HEIGHT, meta.getHeight(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.WATERPRINT_REPEAT, meta.isRepeat(), true);
	}

}
