package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportGridSection;
import com.bokesoft.yigo.meta.report.ReportSectionType;
import com.bokesoft.yigo.meta.report.ReportTablePageBreakPolicy;

public class MetaReportGridSectionAction extends BaseDomAction<MetaReportGridSection> {

	@Override
	public void load(Document document, Element element,
			MetaReportGridSection meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setType(ReportSectionType.parse(DomHelper.readAttr(element, MetaReportConstants.SECTION_TYPE, "")));
		meta.setMinFillRowCount(DomHelper.readAttr(element, MetaReportConstants.SECTION_MINFILLROWCOUNT, 0));
		meta.setPageBreakPolicy(ReportTablePageBreakPolicy.parse(DomHelper.readAttr(element, MetaReportConstants.SECTION_PAGEBREAKPOLICY, ReportTablePageBreakPolicy.STR_None)));
		meta.setSplitRow(DomHelper.readAttr(element, MetaReportConstants.SECTION_SPLITROW, false));
	}

	@Override
	public void save(Document document, Element element,
			MetaReportGridSection meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaReportConstants.SECTION_TYPE, ReportSectionType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaReportConstants.SECTION_MINFILLROWCOUNT, meta.getMinFillRowCount(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.SECTION_PAGEBREAKPOLICY, ReportTablePageBreakPolicy.toString(meta.getPageBreakPolicy()), ReportTablePageBreakPolicy.STR_None);
		DomHelper.writeAttr(element, MetaReportConstants.SECTION_SPLITROW, meta.isSplitRow(), false);
	}

}
