package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.ReportUnderLineStyle;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportFont;

public class MetaReportFontAction extends BaseDomAction<MetaReportFont> {

	@Override
	public void load(Document document, Element element, MetaReportFont meta, int runType) {
		meta.setName(DomHelper.readAttr(element, MetaReportConstants.FONT_NAME, ""));
		meta.setSize(DomHelper.readAttr(element, MetaReportConstants.FONT_SIZE, 12));
		meta.setBold(DomHelper.readAttr(element, MetaReportConstants.FONT_BOLD, false));
		meta.setItalic(DomHelper.readAttr(element, MetaReportConstants.FONT_ITALIC, false));
		meta.setUnderlineStyle(ReportUnderLineStyle.parse(DomHelper.readAttr(element, MetaReportConstants.FONT_UNDERLINE, ReportUnderLineStyle.STR_NONE)));
	}

	@Override
	public void save(Document document, Element element, MetaReportFont meta, int runType) {
		DomHelper.writeAttr(element, MetaReportConstants.FONT_NAME, meta.getName(), "");
		DomHelper.writeAttr(element, MetaReportConstants.FONT_SIZE, meta.getSize(), 12);
		DomHelper.writeAttr(element, MetaReportConstants.FONT_BOLD, meta.isBold(), false);
		DomHelper.writeAttr(element, MetaReportConstants.FONT_ITALIC, meta.isItalic(), false);
		DomHelper.writeAttr(element, MetaReportConstants.FONT_UNDERLINE, ReportUnderLineStyle.toString(meta.getUnderlineStyle()), ReportUnderLineStyle.STR_NONE);
	}

}
