package com.bokesoft.yes.meta.persist.dom.permission.filter;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.MappingDataType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.permission.filter.MetaSourceData;

public class MetaSourceDataAction extends BaseDomAction<MetaSourceData> {

	@Override
	public void load(Document document, Element element, MetaSourceData meta, int runType) {
		meta.setType(MappingDataType.parse(DomHelper.readAttr(element, MetaFilterConstants.TYPE, MappingDataType.STR_FORMULA)));
		meta.setFormula(DomHelper.readAttr(element, MetaFilterConstants.FORMULA, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaFilterConstants.TABLEKEY, ""));
		meta.setColumnKey(DomHelper.readAttr(element, MetaFilterConstants.COLUMNKEY, ""));
		meta.setDetail(DomHelper.readAttr(element, MetaFilterConstants.ISDETAIL, false));
		meta.setParaIndex(DomHelper.readAttr(element, MetaFilterConstants.PARAINDEX, -1));
		meta.setParaKey(DomHelper.readAttr(element, MetaFilterConstants.PARAKEY, ""));
		meta.setDataType(DataType.parse(DomHelper.readAttr(element, MetaFilterConstants.DATATYPE, DataType.STR_INT)));
	}

	@Override
	public void save(Document document, Element element, MetaSourceData meta, int runType) {
		DomHelper.writeAttr(element, MetaFilterConstants.TYPE, MappingDataType.toString(meta.getType()), MappingDataType.STR_FORMULA);
		DomHelper.writeAttr(element, MetaFilterConstants.FORMULA, meta.getFormula(), "");
		DomHelper.writeAttr(element, MetaFilterConstants.TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaFilterConstants.COLUMNKEY, meta.getColumnKey(), "");
		DomHelper.writeAttr(element, MetaFilterConstants.ISDETAIL, meta.isDetail(), false);
		DomHelper.writeAttr(element, MetaFilterConstants.PARAINDEX, meta.getParaIndex(), -1);
		DomHelper.writeAttr(element, MetaFilterConstants.PARAKEY, meta.getParaKey(), "");
		DomHelper.writeAttr(element, MetaFilterConstants.DATATYPE, DataType.toString(meta.getDataType()), DataType.STR_INT);
	}

}
