package com.bokesoft.yes.meta.persist.dom.mapping;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mapping.MetaNode;

public class MetaNodeAction<T extends MetaNode> extends MetaMapElementAction<T> {

	@Override
	public void load(Document document, Element element, T meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setJoinPrimary(DomHelper.readBool(	element,MetaMappingConstants.JOIN_PRIMARY, false));
	}

	@Override
	public void save(Document document, Element element, T meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaMappingConstants.JOIN_PRIMARY, meta.isJoinPrimary(), false);
	}
	
}
