package com.bokesoft.yes.meta.persist.dom.mapping;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.def.MappingJoinType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mapping.MetaJoin;

public class MetaJoinAction extends MetaNodeAction<MetaJoin> {

	@Override
	public void load(Document document, Element element, MetaJoin meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setType(MappingJoinType.parse(DomHelper.readAttr(element, MetaMappingConstants.TYPE, MappingJoinType.STR_UNION)));
	}

	@Override
	public void save(Document document, Element element, MetaJoin meta, int runType) {
		super.save(document, element, meta, runType);
		String type = MappingJoinType.toString(meta.getType());
		DomHelper.writeAttr(element, MetaMappingConstants.TYPE, type, MappingJoinType.STR_UNION);
	}
	
}
