package com.bokesoft.yes.meta.persist.dom.group;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.group.MetaGroup;

public class MetaGroupAction extends BaseDomAction<MetaGroup> {

	@Override
	public void load(Document document, Element element, MetaGroup meta, int runType) {
		meta.setSplitProxyProvider(DomHelper.readAttr(element, GroupConstants.SPLIT_PROXY_PROVIDER, ""));
	}

	@Override
	public void save(Document document, Element element, MetaGroup meta, int runType) {
		DomHelper.writeAttr(element, GroupConstants.SPLIT_PROXY_PROVIDER, meta.getSplitProxyProvider(), "");
	}

}
