package com.bokesoft.yes.meta.persist.dom.form.script;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptExtAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.FormVerb;
import com.bokesoft.yigo.common.def.ScriptRange;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaScript;

public class MetaScriptExtAction extends MetaBaseScriptExtAction<MetaScript> {
	@Override
	public void load(Document document, Element element, MetaScript meta, int runType) {
		super.load(document, element, meta, runType);

		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, null));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, null));
		meta.setRange(ScriptRange.parse(DomHelper.readAttr(element, MetaConstants.SCRIPT_RANGE, "")));
		meta.setVerb(FormVerb.parse(DomHelper.readAttr(element, MetaConstants.SCRIPT_VERB, "")));
	}
	
	@Override
	public void save(Document document, Element element, MetaScript meta, int runType) {

	}
}
