package com.bokesoft.yes.meta.persist.dom.form.script;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.FormVerb;
import com.bokesoft.yigo.common.def.ScriptRange;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaScript;

public class MetaScriptAction extends MetaBaseScriptAction<MetaScript> {
	@Override
	public void load(Document document, Element element, MetaScript meta, int runType) {
		super.load(document, element, meta, runType);

		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setRange(ScriptRange.parse(DomHelper.readAttr(element, MetaConstants.SCRIPT_RANGE, ScriptRange.STR_All)));
		meta.setVerb(FormVerb.parse(DomHelper.readAttr(element, MetaConstants.SCRIPT_VERB, FormVerb.STR_Other)));
	}
	
	@Override
	public void save(Document document, Element element, MetaScript meta, int runType) {
		super.save(document, element, meta, runType);

		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.SCRIPT_RANGE, ScriptRange.toString(meta.getRange()), ScriptRange.STR_All);
		DomHelper.writeAttr(element, MetaConstants.SCRIPT_VERB, FormVerb.toString(meta.getVerb()), FormVerb.STR_Other);
	}
}
