package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutFlowIndex;

public class MetaLayoutFlowIndexAction extends MetaLayoutItemAction {
	@Override
	public void load(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.load(document, element, meta, runType);
		MetaLayoutFlowIndex metaLayoutFlowIndex = (MetaLayoutFlowIndex)meta;
		metaLayoutFlowIndex.setHeight(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMMON_HEIGHT, "")));
	}

	@Override
	public void save(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.save(document, element, meta, runType);
		MetaLayoutFlowIndex metaLayoutFlowIndex = (MetaLayoutFlowIndex)meta;
		DefSize height = metaLayoutFlowIndex.getHeight();
		if ( height != null ) {
			DomHelper.writeAttr(element, MetaConstants.COMMON_HEIGHT, height.toString(), "");
		}
	}
}
