package com.bokesoft.yes.meta.persist.dom.form.component.theme;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.theme.MetaStyle;

public class MetaStyleAction extends BaseDomAction<MetaStyle> {

	@Override
	public void load(Document document, Element element, MetaStyle meta, int runType) {
		meta.setID(DomHelper.readAttr(element, MetaConstants.STYLE_ID, ""));
		meta.setSubID(DomHelper.readAttr(element, MetaConstants.STYLE_SUBID, ""));
		
		NamedNodeMap attributes = element.getAttributes();
		int length = attributes.getLength();
		for (int i = 0; i<length; ++i ) {
			Node node = attributes.item(i);
			String key = node.getNodeName();
			String value = node.getTextContent();
			meta.addProperty(key, value);
		}
	}

	@Override
	public void save(Document document, Element element, MetaStyle meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.STYLE_ID, meta.getID(), "");
		DomHelper.writeAttr(element, MetaConstants.STYLE_SUBID, meta.getSubID(), "");
	}

}
