package com.bokesoft.yes.meta.persist.dom.form.component.panel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.def.ScrollType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;

/**
 * 基础布局面板对象在保存和载入时的相关动作
 * 
 * @author 陈志盛
 * @since YES1.0
 */
public class MetaPanelAction<T extends MetaPanel> extends MetaComponentAction<T> {
	@Override
	public void load(Document document, Element element, T meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setOverflowX(ScrollType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_OVERFLOW_X, ScrollType.STR_Visible)));
		meta.setOverflowY(ScrollType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_OVERFLOW_Y, ScrollType.STR_Visible)));
		meta.setBackImage(DomHelper.readAttr(element, MetaConstants.COMPONENT_BACKIMAGE, ""));
		meta.setBackImagePosition(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_BACKIMAGE_POSITION, "")));
		meta.setBackImageRepeatX(DomHelper.readAttr(element, MetaConstants.COMPONENT_BACKIMAGE_REPEAT_X, false));
		meta.setBackImageRepeatY(DomHelper.readAttr(element, MetaConstants.COMPONENT_BACKIMAGE_REPEAT_Y, false));
		meta.setBackImageScaleType(ImageScaleType.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_BACKIMAGE_SCALE_TYPE, "")));
		meta.setLayoutAnim(DomHelper.readAttr(element, MetaConstants.COMPONENT_LAYOUTANIM, ""));
	}

	@Override
	public void save(Document document, Element element, T meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_OVERFLOW_X, ScrollType.toString(meta.getOverflowX()), ScrollType.STR_Visible);
		DomHelper.writeAttr(element, MetaConstants.COMMON_OVERFLOW_Y, ScrollType.toString(meta.getOverflowY()), ScrollType.STR_Visible);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BACKIMAGE, meta.getBackImage(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BACKIMAGE_POSITION, DirectionType.toString(meta.getBackImagePosition()), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BACKIMAGE_REPEAT_X, meta.isBackImageRepeatX(), false);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BACKIMAGE_REPEAT_Y, meta.isBackImageRepeatY(), false);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BACKIMAGE_SCALE_TYPE, ImageScaleType.toString(meta.getBackImageScaleType()), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_LAYOUTANIM, meta.getLayoutAnim(), "");
	}
}
