package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowAreaExpand;

public class MetaRowAreaExpandAction extends MetaBaseScriptAction<MetaRowAreaExpand>{

	@Override
	public void load(Document document, Element element, MetaRowAreaExpand meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setStart(DomHelper.readAttr(element, MetaConstants.EXPAND_START, -1));
		meta.setCount(DomHelper.readAttr(element, MetaConstants.EXPAND_COUNT, 0));
	}

	@Override
	public void save(Document document, Element element, MetaRowAreaExpand meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.EXPAND_START, meta.getStart(), -1);
		DomHelper.writeAttr(element, MetaConstants.EXPAND_COUNT, meta.getCount(), 0);
	}
}
