package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaTextEditor;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;

public class MetaTextEditorExtPropertiesAction extends DomPropertiesAction<MetaTextEditorProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaTextEditorProperties meta, int runType) {
		meta.setMaxLength(DomHelper.readInt(element, MetaConstants.TEXT_MAXLENGTH, null));
		meta.setShowWordLimit(DomHelper.readBool(element, MetaConstants.TEXT_SHOWWORDLIMIT, null));
		meta.setCaseType(MetaTextEditor.parseCaseType(DomHelper.readAttr(element, MetaConstants.TEXT_CASE, "")));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.TEXT_PROMPTTEXT, null));
		meta.setInvalidChars(DomHelper.readAttr(element, MetaConstants.TEXT_INVALIDCHARS, null));
		meta.setTrim(DomHelper.readBool(element, MetaConstants.TEXT_TRIM, null));
		meta.setSelectOnFocus(DomHelper.readBool(element, MetaConstants.TEXT_SELECTONFOCUS, null));
		meta.setMask(DomHelper.readAttr(element, MetaConstants.TEXT_MASK, null));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.TEXT_ICON, null));
		meta.setPreIcon(DomHelper.readAttr(element, MetaConstants.TEXT_PREICON, null));
		meta.setEmbedText(DomHelper.readAttr(element, MetaConstants.TEXT_EMBEDTEXT, null));
		meta.setHoldFocus(DomHelper.readBool(element, MetaConstants.TEXT_HOLDFOCUS, null));
		meta.setDisableKeyboard(DomHelper.readBool(element, MetaConstants.TEXT_DISABLEKEYBOARD, null));
		meta.setSuffix(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_SUFFIX, ""));
		meta.setPrefix(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_PREFIX, ""));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaTextEditorProperties meta, int runType) {
		
	}

}
