package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaTextEditor;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextButtonProperties;

public class MetaTextButtonExtPropertiesAction extends DomPropertiesAction<MetaTextButtonProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaTextButtonProperties meta, int runType) {
		meta.setMaxLength(DomHelper.readInt(element, MetaConstants.TEXT_MAXLENGTH, null));
		meta.setCaseType(MetaTextEditor.parseCaseType(DomHelper.readAttr(element, MetaConstants.TEXT_CASE, "")));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.TEXT_PROMPTTEXT, null));
		meta.setInvalidChars(DomHelper.readAttr(element, MetaConstants.TEXT_INVALIDCHARS, null));
		meta.setTrim(DomHelper.readBool(element, MetaConstants.TEXT_TRIM, null));
		meta.setSelectOnFocus(DomHelper.readBool(element, MetaConstants.TEXT_SELECTONFOCUS, null));
		meta.setMask(DomHelper.readAttr(element, MetaConstants.TEXT_MASK, null));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.TEXT_ICON, null));
		meta.setPreIcon(DomHelper.readAttr(element, MetaConstants.TEXT_PREICON, null));
		meta.setEmbedText(DomHelper.readAttr(element, MetaConstants.TEXT_EMBEDTEXT, null));
		meta.setHoldFocus(DomHelper.readBool(element, MetaConstants.TEXT_HOLDFOCUS, null));
		meta.setUseFormulaModel(DomHelper.readBool(element, MetaConstants.TEXT_USEFORMULAMODEL, null));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaTextButtonProperties meta, int runType) {

	}

}
