package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaWizardListProperties;

public class MetaWizardListPropertiesAction extends DomPropertiesAction<MetaWizardListProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaWizardListProperties meta, int runType) {
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.PROMPTTEXT, ""));
		meta.setEditType(SelectEditType.parse(DomHelper.readAttr(element, MetaConstants.WIZARDLIST_EDITTYPE, SelectEditType.STR_POP)));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaWizardListProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.PROMPTTEXT, meta.getPromptText(), "");
		DomHelper.writeAttr(element, MetaConstants.WIZARDLIST_EDITTYPE, SelectEditType.format(meta.getEditType()), SelectEditType.STR_POP);
	}

}
