package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.def.ProgressIndicatorSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressIndicatorProperties;

public class MetaProgressIndicatorPropertiesAction extends DomPropertiesAction<MetaProgressIndicatorProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaProgressIndicatorProperties meta, int runType) {
		meta.setSourceType(ProgressIndicatorSourceType.parse(DomHelper.readAttr(element,
				MetaConstants.PROGRESSINDICATOR_SOURCETYPE, ProgressIndicatorSourceType.STR_ITEMS)));
		meta.setCompletedIcon(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_COMPLETEDICON, ""));
		meta.setAttentionIcon(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_ATTENTIONICON, ""));
		meta.setAttentionTextColor(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_ATTENTIONTEXTCOLOR, ""));
		meta.setDefaultIcon(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_DEFAULTICON, ""));
		meta.setUnCompletedLineColor(
				DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_UNCOMPLETEDLINECOLOR, ""));
		meta.setUnCompletedTextColor(
				DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_UNCOMPLETEDTEXTCOLOR, ""));
		meta.setCompletedLineColor(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_COMPLETEDLINECOLOR, ""));
		meta.setCompletedTextColor(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_COMPLETEDTEXTCOLOR, ""));
		meta.setOrientation(OrientationType.parse(
				DomHelper.readAttr(element, MetaConstants.COMPONENT_ORIENTATION, OrientationType.STR_Horizontal)));
		meta.setReverseDraw(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_REVERSEDRAW, false));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_TABLEKEY, ""));
		meta.setTitleColumnKey(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_TITLECOLUMNKEY, ""));
		meta.setMessageColumnKey(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_MESSAGECOLUMNKEY, ""));
		meta.setDateTimeColumnKey(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_DATETIMECOLUMNKEY, ""));
		meta.setScroll(DomHelper.readAttr(element, MetaConstants.PROGRESSINDICATOR_ISSCROLL, true));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaProgressIndicatorProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_SOURCETYPE,
				ProgressIndicatorSourceType.toString(meta.getSourceType()), ProgressIndicatorSourceType.STR_ITEMS);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_COMPLETEDICON, meta.getCompletedIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_ATTENTIONICON, meta.getAttentionIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_ATTENTIONTEXTCOLOR, meta.getAttentionTextColor(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_DEFAULTICON, meta.getDefaultIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_UNCOMPLETEDLINECOLOR, meta.getUnCompletedLineColor(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_UNCOMPLETEDTEXTCOLOR, meta.getUnCompletedTextColor(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_COMPLETEDLINECOLOR, meta.getCompletedLineColor(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_COMPLETEDTEXTCOLOR, meta.getCompletedTextColor(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_ORIENTATION,
				OrientationType.toString(meta.getOrientation()), OrientationType.STR_Horizontal);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_REVERSEDRAW, meta.isReverseDraw(), false);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_TITLECOLUMNKEY, meta.getTitleColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_MESSAGECOLUMNKEY, meta.getMessageColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_DATETIMECOLUMNKEY, meta.getDateTimeColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.PROGRESSINDICATOR_ISSCROLL, meta.isScroll(), true);
	}

}
