package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.component.control.MetaHyperLink;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;

public class MetaHyperLinkPropertiesAction extends DomPropertiesAction<MetaHyperLinkProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaHyperLinkProperties meta, int runType) {
		meta.setTargetShowType(MetaHyperLink.parseTargetShowType(DomHelper.readAttr(element, MetaConstants.HYPERLINK_TAEGETSHOWTYPE, "NewTab")));
		meta.setURL(DomHelper.readAttr(element, MetaConstants.HYPERLINK_URL, ""));
		meta.setFormulaURL(DomHelper.readAttr(element, MetaConstants.HYPERLINK_FORMULAURL, ""));
		meta.setNeedAuthenticate(DomHelper.readBool(element, MetaConstants.HYPERLINK_NEEDAUTHENTICATE, false));
		meta.setCheckOnClickNode(DomHelper.readAttr(element, MetaConstants.COMMON_CHECK_ON_CLICK_NODE, false));
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaHyperLinkProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.HYPERLINK_TAEGETSHOWTYPE, MetaHyperLink.getTargetShowTypeStr(meta.getTargetShowType()), "NewTab");
		DomHelper.writeAttr(element, MetaConstants.HYPERLINK_URL, meta.getURL(), "");
		DomHelper.writeAttr(element, MetaConstants.HYPERLINK_FORMULAURL, meta.getFormulaURL(), "");
		DomHelper.writeAttr(element, MetaConstants.HYPERLINK_NEEDAUTHENTICATE, meta.isNeedAuthenticate(), false);
		DomHelper.writeAttr(element, MetaConstants.COMMON_CHECK_ON_CLICK_NODE, meta.getCheckOnClickNode(), false);
	}

}
